/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.ClusterLockState;
import org.jboss.ha.framework.server.lock.LocalLockHandler;
import org.jboss.ha.framework.server.lock.RemoteLockResponse;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.logging.Logger;

public abstract class AbstractClusterLockSupport
implements HAPartition.HAMembershipListener {
    public static final Class<?>[] REMOTE_LOCK_TYPES = new Class[]{Serializable.class, ClusterNode.class, Long.TYPE};
    public static final Class<?>[] RELEASE_REMOTE_LOCK_TYPES = new Class[]{Serializable.class, ClusterNode.class};
    protected final Logger log = Logger.getLogger(this.getClass());
    private final ConcurrentMap<Serializable, ClusterLockState> lockStates = new ConcurrentHashMap<Serializable, ClusterLockState>();
    private final ConcurrentMap<ClusterNode, Set<ClusterLockState>> lockStatesByOwner = new ConcurrentHashMap<ClusterNode, Set<ClusterLockState>>();
    private ClusterNode me;
    private final String serviceHAName;
    private final HAPartition partition;
    private final LocalLockHandler localHandler;
    private final List<ClusterNode> members = new CopyOnWriteArrayList<ClusterNode>();
    private RpcTarget rpcTarget;

    public AbstractClusterLockSupport(String serviceHAName, HAPartition partition, LocalLockHandler handler) {
        if (serviceHAName == null) {
            throw new IllegalArgumentException("serviceHAName is null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("partition is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("localHandler is null");
        }
        this.partition = partition;
        this.localHandler = handler;
        this.serviceHAName = serviceHAName;
    }

    public HAPartition getPartition() {
        return this.partition;
    }

    public String getServiceHAName() {
        return this.serviceHAName;
    }

    public LocalLockHandler getLocalHandler() {
        return this.localHandler;
    }

    public boolean lock(Serializable lockId, long timeout) {
        if (this.rpcTarget == null) {
            throw new IllegalStateException("Must call start() before first call to lock()");
        }
        ClusterLockState category = this.getClusterLockState(lockId, true);
        long left = timeout > 0L ? timeout : Long.MAX_VALUE;
        long start = System.currentTimeMillis();
        while (left > 0L) {
            long backoff;
            ClusterNode superiorCompetitor;
            block21: {
                superiorCompetitor = null;
                if (category.state.compareAndSet(ClusterLockState.State.UNLOCKED, ClusterLockState.State.REMOTE_LOCKING)) {
                    boolean success = false;
                    try {
                        List<RemoteLockResponse> rsps = this.partition.callMethodOnCluster(this.getServiceHAName(), "remoteLock", new Object[]{lockId, this.me, new Long(left)}, REMOTE_LOCK_TYPES, RemoteLockResponse.class, true, null, this.partition.getMethodCallTimeout(), false);
                        boolean remoteLocked = true;
                        if (rsps != null) {
                            for (RemoteLockResponse rsp : rsps) {
                                if (rsp.flag == RemoteLockResponse.Flag.OK) continue;
                                remoteLocked = false;
                                if (superiorCompetitor != null) continue;
                                superiorCompetitor = this.getSuperiorCompetitor(rsp.holder);
                                this.log.debug((Object)("Received " + (Object)((Object)rsp.flag) + " response from " + rsp.responder + " -- reports lock is held by " + rsp.holder));
                            }
                        } else if (this.members.size() == 1 && this.members.contains(this.me) || this.members.size() == 0) {
                            remoteLocked = true;
                        }
                        if (!remoteLocked) break block21;
                        if (category.state.compareAndSet(ClusterLockState.State.REMOTE_LOCKING, ClusterLockState.State.LOCAL_LOCKING)) {
                            long localTimeout = left - (System.currentTimeMillis() - start);
                            if (this.getLock((Serializable)lockId, (ClusterLockState)category, (ClusterNode)this.me, (long)localTimeout).flag == RemoteLockResponse.Flag.OK) {
                                success = true;
                                return true;
                            }
                        }
                        try {
                            superiorCompetitor = this.getSuperiorCompetitor(category.getHolder());
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        if (!success) {
                            this.cleanup(lockId, category);
                        }
                    }
                }
            }
            if ((backoff = AbstractClusterLockSupport.computeBackoff(timeout, start, left, superiorCompetitor == null)) > 0L) {
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (category.state.get() == ClusterLockState.State.INVALID) {
                category = this.getClusterLockState(lockId, true);
            }
            long now = System.currentTimeMillis();
            left -= now - start;
            start = now;
        }
        return false;
    }

    public abstract void unlock(Serializable var1);

    public String getPartitionName() {
        return this.partition.getPartitionName();
    }

    public ClusterNode getLocalClusterNode() {
        return this.me;
    }

    public List<ClusterNode> getCurrentView() {
        return new ArrayList<ClusterNode>(this.members);
    }

    public void start() throws Exception {
        this.me = this.partition.getClusterNode();
        this.localHandler.setLocalNode(this.me);
        this.rpcTarget = new RpcTarget(this);
        this.partition.registerRPCHandler(this.serviceHAName, this.rpcTarget);
        this.partition.registerMembershipListener(this);
        Vector<ClusterNode> allMembers = new Vector<ClusterNode>();
        ClusterNode[] clusterNodeArray = this.partition.getClusterNodes();
        int n = clusterNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterNode node = clusterNodeArray[n2];
            allMembers.add(node);
            ++n2;
        }
        this.membershipChanged(new Vector(), (Vector)allMembers, (Vector)allMembers);
    }

    public void stop() throws Exception {
        if (this.rpcTarget != null) {
            this.partition.unregisterRPCHandler(this.serviceHAName, this.rpcTarget);
            this.rpcTarget = null;
            this.partition.unregisterMembershipListener(this);
            Vector<ClusterNode> dead = new Vector<ClusterNode>(this.members);
            Vector empty = new Vector();
            this.membershipChanged((Vector)dead, empty, empty);
            this.me = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        this.members.clear();
        this.members.addAll(allMembers);
        Set toClean = this.lockStatesByOwner.keySet();
        toClean.removeAll(this.members);
        for (ClusterNode deadMember : toClean) {
            Set deadMemberLocks = (Set)this.lockStatesByOwner.remove(deadMember);
            if (deadMemberLocks == null) continue;
            Set set = deadMemberLocks;
            synchronized (set) {
                HashSet copy = new HashSet(deadMemberLocks);
                for (ClusterLockState lockState : copy) {
                    this.releaseRemoteLock(lockState.lockId, deadMember);
                }
            }
        }
    }

    protected abstract RemoteLockResponse handleLockSuccess(ClusterLockState var1, ClusterNode var2);

    protected abstract ClusterLockState getClusterLockState(Serializable var1);

    protected abstract RemoteLockResponse yieldLock(ClusterLockState var1, ClusterNode var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordLockHolder(ClusterLockState lockState, ClusterNode caller) {
        Set<ClusterLockState> set;
        Set<ClusterLockState> memberLocks;
        if (lockState.holder != null) {
            set = memberLocks = this.getLocksHeldByMember(lockState.holder);
            synchronized (set) {
                memberLocks.remove(lockState);
            }
        }
        if (!this.me.equals(caller)) {
            set = memberLocks = this.getLocksHeldByMember(caller);
            synchronized (set) {
                memberLocks.add(lockState);
            }
        }
        lockState.lock(caller);
    }

    protected ClusterLockState getClusterLockState(Serializable lockName, boolean create) {
        ClusterLockState existing;
        ClusterLockState category = (ClusterLockState)this.lockStates.get(lockName);
        if (category == null && create && (existing = this.lockStates.putIfAbsent(lockName, category = new ClusterLockState(lockName))) != null) {
            category = existing;
        }
        return category;
    }

    protected void removeLockState(ClusterLockState lockState) {
        this.lockStates.remove(lockState.lockId, lockState);
    }

    private RemoteLockResponse remoteLock(Serializable lockName, ClusterNode caller, long timeout) {
        RemoteLockResponse response = null;
        ClusterLockState lockState = this.getClusterLockState(lockName);
        if (lockState == null) {
            return new RemoteLockResponse(this.me, RemoteLockResponse.Flag.OK);
        }
        switch (lockState.state.get()) {
            case UNLOCKED: {
                response = this.getLock(lockName, lockState, caller, timeout);
                break;
            }
            case REMOTE_LOCKING: {
                if (this.me.equals(caller)) {
                    this.log.warn((Object)"Received remoteLock call from self");
                    response = new RemoteLockResponse(this.me, RemoteLockResponse.Flag.OK);
                    break;
                }
                if (this.getSuperiorCompetitor(caller) == null) {
                    response = new RemoteLockResponse(this.me, RemoteLockResponse.Flag.REJECT, this.me);
                    break;
                }
                response = this.getLock(lockName, lockState, caller, timeout);
                break;
            }
            case LOCAL_LOCKING: {
                response = new RemoteLockResponse(this.me, RemoteLockResponse.Flag.REJECT, this.me);
                break;
            }
            case LOCKED: {
                response = this.yieldLock(lockState, caller, timeout);
                break;
            }
            case INVALID: {
                Thread.yield();
                response = this.remoteLock(lockName, caller, timeout);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRemoteLock(Serializable categoryName, ClusterNode caller) {
        ClusterLockState lockState = this.getClusterLockState(categoryName, false);
        if (lockState != null && lockState.state.get() == ClusterLockState.State.LOCKED && caller.equals(this.localHandler.getLockHolder(categoryName))) {
            Set<ClusterLockState> memberLocks;
            lockState.invalidate();
            this.localHandler.unlockFromCluster(categoryName, caller);
            Set<ClusterLockState> set = memberLocks = this.getLocksHeldByMember(caller);
            synchronized (set) {
                memberLocks.remove(lockState);
            }
            this.removeLockState(lockState);
        }
    }

    private ClusterNode getSuperiorCompetitor(ClusterNode caller) {
        if (caller == null) {
            return null;
        }
        for (ClusterNode node : this.members) {
            if (this.me.equals(node)) break;
            if (!caller.equals(node)) continue;
            return caller;
        }
        return null;
    }

    protected RemoteLockResponse getLock(Serializable categoryName, ClusterLockState category, ClusterNode caller, long timeout) {
        try {
            this.localHandler.lockFromCluster(categoryName, caller, timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)("Caught InterruptedException; Failing request by " + caller + " to lock " + categoryName));
            return new RemoteLockResponse(this.me, RemoteLockResponse.Flag.FAIL, this.localHandler.getLockHolder(categoryName));
        }
        catch (TimeoutException t) {
            return new RemoteLockResponse(this.me, RemoteLockResponse.Flag.FAIL, t.getOwner());
        }
        RemoteLockResponse response = this.handleLockSuccess(category, caller);
        return response;
    }

    private Set<ClusterLockState> getLocksHeldByMember(ClusterNode member) {
        Set existing;
        Set memberCategories = (HashSet)this.lockStatesByOwner.get(member);
        if (memberCategories == null && (existing = (Set)this.lockStatesByOwner.putIfAbsent(member, memberCategories = new HashSet())) != null) {
            memberCategories = existing;
        }
        return memberCategories;
    }

    private void cleanup(Serializable categoryName, ClusterLockState category) {
        try {
            try {
                this.partition.callMethodOnCluster(this.getServiceHAName(), "releaseRemoteLock", new Object[]{categoryName, this.me}, RELEASE_REMOTE_LOCK_TYPES, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed releasing remote lock", e);
            }
        }
        finally {
            if (!category.state.compareAndSet(ClusterLockState.State.REMOTE_LOCKING, ClusterLockState.State.UNLOCKED)) {
                category.state.compareAndSet(ClusterLockState.State.LOCAL_LOCKING, ClusterLockState.State.UNLOCKED);
            }
        }
    }

    private static long computeBackoff(long initialTimeout, long start, long left, boolean superiorCompetitor) {
        long remain = left - (System.currentTimeMillis() - start);
        if (remain < Math.min(initialTimeout / 5L, 15L)) {
            return remain;
        }
        long max = superiorCompetitor ? 100 : 250;
        long min = remain / 3L;
        return Math.min(max, min);
    }

    public static class RpcTarget {
        private final AbstractClusterLockSupport mgr;

        private RpcTarget(AbstractClusterLockSupport mgr) {
            this.mgr = mgr;
        }

        public RemoteLockResponse remoteLock(Serializable categoryName, ClusterNode caller, long timeout) {
            return this.mgr.remoteLock(categoryName, caller, timeout);
        }

        public void releaseRemoteLock(Serializable categoryName, ClusterNode caller) {
            this.mgr.releaseRemoteLock(categoryName, caller);
        }
    }
}

