/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.lookup.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Set;
import lombok.NonNull;
import org.jboss.da.model.rest.NPMPackage;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=NPMLookupRequestBuilder.class)
public class NPMLookupRequest {
    @NonNull
    private final Set<NPMPackage> packages;
    @NonNull
    private final String mode;

    NPMLookupRequest(@NonNull Set<NPMPackage> packages, @NonNull String mode) {
        if (packages == null) {
            throw new NullPointerException("packages is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.packages = packages;
        this.mode = mode;
    }

    public static NPMLookupRequestBuilder builder() {
        return new NPMLookupRequestBuilder();
    }

    @NonNull
    public Set<NPMPackage> getPackages() {
        return this.packages;
    }

    @NonNull
    public String getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NPMLookupRequest)) {
            return false;
        }
        NPMLookupRequest other = (NPMLookupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<NPMPackage> this$packages = this.getPackages();
        Set<NPMPackage> other$packages = other.getPackages();
        if (this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NPMLookupRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<NPMPackage> $packages = this.getPackages();
        result = result * 59 + ($packages == null ? 43 : ((Object)$packages).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public String toString() {
        return "NPMLookupRequest(packages=" + this.getPackages() + ", mode=" + this.getMode() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class NPMLookupRequestBuilder {
        private Set<NPMPackage> packages;
        private String mode;

        NPMLookupRequestBuilder() {
        }

        public NPMLookupRequestBuilder packages(@NonNull Set<NPMPackage> packages) {
            if (packages == null) {
                throw new NullPointerException("packages is marked non-null but is null");
            }
            this.packages = packages;
            return this;
        }

        public NPMLookupRequestBuilder mode(@NonNull String mode) {
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.mode = mode;
            return this;
        }

        public NPMLookupRequest build() {
            return new NPMLookupRequest(this.packages, this.mode);
        }

        public String toString() {
            return "NPMLookupRequest.NPMLookupRequestBuilder(packages=" + this.packages + ", mode=" + this.mode + ")";
        }
    }
}

