/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.model.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.NonNull;

public class GA
implements Comparable<GA> {
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("(\\w[\\w-]*\\.)*\\w[\\w-]*");
    private static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
    @NonNull
    private final String groupId;
    @NonNull
    private final String artifactId;

    @JsonCreator
    public GA(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public boolean isValid() {
        return GROUP_ID_PATTERN.matcher(this.groupId).matches() && ARTIFACT_ID_PATTERN.matcher(this.artifactId).matches();
    }

    @Override
    public int compareTo(GA o) {
        int grpIdCmp = this.groupId.compareTo(o.groupId);
        if (grpIdCmp == 0) {
            return this.artifactId.compareTo(o.artifactId);
        }
        return grpIdCmp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GA)) {
            return false;
        }
        GA other = (GA)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GA;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }
}

