/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.users;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.users.Role;
import org.jboss.dashboard.users.RoleImpl;
import org.jboss.dashboard.users.RolesManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

@ApplicationScoped
public class RolesManagerImpl
implements RolesManager {
    @Inject
    protected Application application;
    @Inject
    @Config(value="admin=Administrator,user=User")
    protected String[] rolesConfig;
    protected transient Map<String, Role> roleMap;
    protected transient Role roleAnonymous;

    @PostConstruct
    public void init() throws Exception {
        this.roleAnonymous = new RoleImpl("anonymous", "Anonymous");
        this.roleMap = new HashMap<String, Role>();
        this.roleMap.put(this.roleAnonymous.getName(), this.roleAnonymous);
        File webXml = new File(this.application.getBaseAppDirectory() + File.separator + "WEB-INF/web.xml");
        if (webXml.exists()) {
            this.registerRolesFromWebXml(webXml);
        } else {
            this.registerRolesFromConfig();
        }
    }

    protected void registerRolesFromConfig() throws Exception {
        for (int i = 0; i < this.rolesConfig.length; ++i) {
            String[] arr = this.rolesConfig[i].split("=");
            if (arr.length != 2) {
                throw new IllegalArgumentException("Error: illegal role definition");
            }
            this.roleMap.put(arr[0], new RoleImpl(arr[0], arr[1]));
        }
    }

    protected void registerRolesFromWebXml(File webXml) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(webXml);
        Element root = doc.getRootElement();
        List bundleNodes = root.getChildren("security-role");
        for (Element el_role : bundleNodes) {
            List ch_role = el_role.getChildren();
            RoleImpl role = new RoleImpl();
            for (int i = 0; i < ch_role.size(); ++i) {
                Element el_child = (Element)ch_role.get(i);
                if (el_child.getName().equals("role-name")) {
                    role.setName(el_child.getValue().trim());
                }
                if (!el_child.getName().equals("description")) continue;
                role.setDescription(el_child.getValue().trim());
            }
            if (StringUtils.isBlank((String)role.getName())) continue;
            this.roleMap.put(role.getName(), role);
        }
    }

    @Override
    public Role getRoleById(String id) {
        return this.roleMap.get(id);
    }

    @Override
    public Set<Role> getAllRoles() {
        HashSet<Role> _roles = new HashSet<Role>(this.roleMap.size());
        _roles.addAll(this.roleMap.values());
        return _roles;
    }
}

