/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.security.PermissionDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="permissionManager")
public class PermissionManager {
    private static transient Logger log = LoggerFactory.getLogger((String)PermissionManager.class.getName());

    public static PermissionManager lookup() {
        return (PermissionManager)CDIBeanLocator.getBeanByName((String)"permissionManager");
    }

    public PermissionDescriptor createNewItem() {
        return new PermissionDescriptor();
    }

    public List<PermissionDescriptor> getAllInstances() throws Exception {
        return this.find((String)null);
    }

    public PermissionDescriptor find(final Principal prpal, final Permission perm) {
        final ArrayList results = new ArrayList(1);
        HibernateTxFragment txFragment = new HibernateTxFragment(){

            protected void txFragment(Session session) throws Exception {
                StringBuffer buf = new StringBuffer();
                buf.append(" from " + PermissionDescriptor.class.getName() + " as item where item.dbid is not null ");
                if (prpal != null) {
                    buf.append(" and item.principalClass = :principalClass  ");
                    buf.append(" and item.principalName =  :principalName  ");
                }
                buf.append("and item.permissionClass = :permissionClass and item.permissionResource = :permissionResource");
                Query query = session.createQuery(buf.toString());
                if (prpal != null) {
                    query.setString("principalClass", prpal.getClass().getName());
                    query.setString("principalName", prpal.getName());
                }
                query.setString("permissionClass", perm.getClass().getName());
                query.setString("permissionResource", perm.getName());
                query.setCacheable(true);
                FlushMode oldFlushMode = session.getFlushMode();
                session.setFlushMode(FlushMode.NEVER);
                results.addAll(query.list());
                session.setFlushMode(oldFlushMode);
            }
        };
        try {
            txFragment.execute();
            if (!results.isEmpty()) {
                return (PermissionDescriptor)results.get(0);
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error retrieving PermissionDescriptor", (Throwable)e);
            return null;
        }
    }

    public List<PermissionDescriptor> find(final String resourceName) throws Exception {
        final ArrayList<PermissionDescriptor> results = new ArrayList<PermissionDescriptor>();
        new HibernateTxFragment(){

            protected void txFragment(Session session) throws Exception {
                StringBuffer buf = new StringBuffer();
                buf.append(" from " + PermissionDescriptor.class.getName() + " as item where item.dbid is not null ");
                if (!StringUtils.isBlank((String)resourceName)) {
                    buf.append(" and item.permissionResource = :res1 or  item.permissionResource = :res2");
                }
                Query query = session.createQuery(buf.toString());
                if (!StringUtils.isBlank((String)resourceName)) {
                    query.setString("res1", resourceName);
                    query.setString("res2", resourceName + ".*");
                }
                query.setCacheable(true);
                FlushMode oldFlushMode = session.getFlushMode();
                session.setFlushMode(FlushMode.NEVER);
                results.addAll(query.list());
                session.setFlushMode(oldFlushMode);
            }
        }.execute();
        return results;
    }

    public List<PermissionDescriptor> find(String permissionClass, String permissionResource) {
        return this.find(permissionClass, permissionResource, Boolean.TRUE);
    }

    public List<PermissionDescriptor> find(final String permissionClass, final String permissionResource, final Boolean includeReadOnly) {
        final ArrayList<PermissionDescriptor> results = new ArrayList<PermissionDescriptor>(10);
        HibernateTxFragment txFragment = new HibernateTxFragment(){

            protected void txFragment(Session session) throws Exception {
                StringBuffer buf = new StringBuffer(" from " + PermissionDescriptor.class.getName() + " as item where item.dbid is not null ");
                buf.append("and item.permissionClass = :permissionClass and item.permissionResource = :permissionResource");
                if (!includeReadOnly.booleanValue()) {
                    buf.append(" and item.readonly = :readonly");
                }
                Query query = session.createQuery(buf.toString());
                query.setString("permissionClass", permissionClass);
                query.setString("permissionResource", permissionResource);
                if (!includeReadOnly.booleanValue()) {
                    query.setBoolean("readonly", includeReadOnly.booleanValue());
                }
                query.setCacheable(true);
                FlushMode oldFlushMode = session.getFlushMode();
                session.setFlushMode(FlushMode.NEVER);
                results.addAll(query.list());
                session.setFlushMode(oldFlushMode);
            }
        };
        try {
            txFragment.execute();
        }
        catch (Exception e) {
            log.error("Error retrieving PermissionDescriptors for permission class " + permissionClass + " and resource " + permissionResource, (Throwable)e);
        }
        return results;
    }

    public PermissionDescriptor findPermissionDescriptorById(final Long idPermission) {
        final ArrayList result = new ArrayList(1);
        try {
            new HibernateTxFragment(){

                protected void txFragment(Session session) throws Exception {
                    String sql = new String(" from " + PermissionDescriptor.class.getName() + " as item where item.dbid = :dbid");
                    Query query = session.createQuery(sql);
                    query.setLong("dbid", idPermission.longValue());
                    FlushMode oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.NEVER);
                    result.add((PermissionDescriptor)query.uniqueResult());
                    session.setFlushMode(oldFlushMode);
                }
            }.execute();
        }
        catch (Exception e) {
            log.error("PermissionDescriptor with id " + idPermission + " not found!", (Throwable)e);
        }
        return (PermissionDescriptor)result.get(0);
    }

    public List<PermissionDescriptor> find(List<Long> permissionIds) {
        final ArrayList<PermissionDescriptor> results = new ArrayList<PermissionDescriptor>(10);
        if (permissionIds != null) {
            final StringBuilder idString = new StringBuilder(" from " + PermissionDescriptor.class.getName() + " as item where item.dbid in (");
            for (int i = 0; i < permissionIds.size(); ++i) {
                idString.append(permissionIds.get(i));
                if (i == permissionIds.size() - 1) continue;
                idString.append(",");
            }
            idString.append(")");
            HibernateTxFragment txFragment = new HibernateTxFragment(){

                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery(idString.toString());
                    FlushMode oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.NEVER);
                    results.addAll(query.list());
                    session.setFlushMode(oldFlushMode);
                }
            };
            try {
                txFragment.execute();
            }
            catch (Exception e) {
                log.error("Error deleting PermissionDescriptors with dbids in (" + idString + ")", (Throwable)e);
            }
        }
        return results;
    }
}

