/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.users;

import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.SecurityServices;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.security.AccessController;
import org.jboss.dashboard.security.SecurityCache;
import org.jboss.dashboard.security.principals.ComplementaryRolePrincipal;
import org.jboss.dashboard.security.principals.DefaultPrincipal;
import org.jboss.dashboard.security.principals.RolePrincipal;
import org.jboss.dashboard.security.principals.UserPrincipal;
import org.jboss.dashboard.users.LogoutSurvivor;
import org.jboss.dashboard.users.Role;
import org.jboss.dashboard.users.RolesManager;
import org.jboss.dashboard.users.UserStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named(value="userStatus")
public class UserStatus
implements LogoutSurvivor,
Serializable {
    private static transient Logger log = LoggerFactory.getLogger((String)UserStatus.class.getName());
    @Inject
    @Config(value="root")
    protected String rootLogin;
    @Inject
    @Config(value="root")
    protected String rootUserName;
    @Inject
    protected SecurityCache securityCache;
    @Inject
    @Install
    protected Instance<UserStatusListener> statusChangedListeners;
    protected transient String userLogin;
    protected transient String userName;
    protected transient String userEmail;
    protected transient Set<String> userRoleIds = new HashSet<String>();
    protected transient Subject userAuth;

    public static UserStatus lookup() {
        return (UserStatus)CDIBeanLocator.getBeanByName((String)"userStatus");
    }

    public UserStatus() {
        this.clear();
        this.userRoleIds.add("anonymous");
    }

    public String getRootLogin() {
        return this.rootLogin;
    }

    public void setRootLogin(String rootLogin) {
        this.rootLogin = rootLogin;
    }

    public String getRootUserName() {
        return this.rootUserName;
    }

    public void setRootUserName(String rootUserName) {
        this.rootUserName = rootUserName;
    }

    protected void notifyStatusChanged() {
        for (UserStatusListener statusChangedListener : this.statusChangedListeners) {
            statusChangedListener.statusChanged(this);
        }
    }

    public AccessController getAccessController() {
        return SecurityServices.lookup().getAccessController();
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public String getUserName() {
        return this.isLoggedIn() ? this.userName : "--";
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Set<String> getUserRoleIds() {
        return this.userRoleIds;
    }

    public void setUserRoleIds(Set<String> userRoleIds) {
        this.userRoleIds = userRoleIds;
    }

    public boolean isRootUser() {
        return this.userLogin != null && this.userLogin.equals(this.rootLogin);
    }

    public boolean isLoggedIn() {
        return !StringUtils.isBlank((String)this.userLogin);
    }

    public boolean isAnonymous() {
        return StringUtils.isBlank((String)this.userLogin);
    }

    public synchronized void initSession(String login, Collection<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            throw new IllegalArgumentException("User session initialization failed: the list of roles is empty.");
        }
        this.clear();
        this.userLogin = login;
        this.userRoleIds.addAll(roleIds);
        this.invalidateUserPrincipals();
        this.notifyStatusChanged();
    }

    public synchronized void initSessionAsRoot() {
        this.clear();
        this.userLogin = this.rootLogin;
        this.userName = this.rootUserName;
        this.invalidateUserPrincipals();
        this.notifyStatusChanged();
    }

    public synchronized void closeSession() {
        this.clear();
        this.userRoleIds.add("anonymous");
        this.invalidateUserPrincipals();
        this.notifyStatusChanged();
    }

    public synchronized void invalidateUserPrincipals() {
        if (log.isDebugEnabled()) {
            log.debug("Security information is obsolete. Clearing.");
        }
        this.securityCache.clear();
        Set<Principal> userPrincipals = this.calculateUserPrincipals();
        this.userAuth = new Subject(false, userPrincipals, new HashSet(), new HashSet());
    }

    public void checkPermission(Permission perm) throws SecurityException {
        if (!this.hasPermission(perm)) {
            throw new SecurityException("Permission denied.\r\npermission=" + perm.toString() + "\r\n");
        }
    }

    public boolean hasPermission(Permission perm) {
        Boolean b;
        if (this.isRootUser()) {
            return true;
        }
        if (this.securityCache.isCacheEnabled() && (b = this.securityCache.getValue(perm, perm.getActions())) != null) {
            return b;
        }
        boolean result = this.evaluatePermission(perm);
        if (this.securityCache.isCacheEnabled()) {
            this.securityCache.setValue(perm, perm.getActions(), result);
        }
        return result;
    }

    protected void clear() {
        this.userLogin = null;
        this.userName = null;
        this.userEmail = null;
        this.userAuth = null;
        this.userRoleIds.clear();
    }

    protected boolean evaluatePermission(Permission perm) {
        if (this.userAuth == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoking accessController to determine if permission " + perm + " is granted.");
        }
        boolean result = this.getAccessController().hasPermission(this.userAuth, perm);
        if (log.isDebugEnabled()) {
            log.debug("AccessController determines that permission " + perm + " is " + (result ? "" : "NOT ") + "granted.");
        }
        return result;
    }

    protected Set<Principal> calculateUserPrincipals() {
        if (log.isDebugEnabled()) {
            log.debug("Calculating principals for current user.");
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        if (this.userLogin != null) {
            principals.add(new UserPrincipal(this.userLogin));
        }
        if (!this.isRootUser()) {
            RolesManager rolesManager = SecurityServices.lookup().getRolesManager();
            for (Role role : rolesManager.getAllRoles()) {
                DefaultPrincipal rolePrincipal = null;
                rolePrincipal = this.userRoleIds.contains(role.getName()) ? new RolePrincipal(role) : new ComplementaryRolePrincipal(role);
                principals.add(rolePrincipal);
            }
        }
        return principals;
    }
}

