/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.TransientRepository;
import org.jboss.dna.common.util.FileUtil;
import org.jboss.dna.common.util.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractJcrRepositoryTest {
    public static final String TESTDATA_PATH = "./src/test/resources/";
    public static final String JACKRABBIT_DATA_PATH = "./target/testdata/jackrabbittest/";
    public static final String REPOSITORY_DIRECTORY_PATH = "./target/testdata/jackrabbittest/repository";
    public static final String REPOSITORY_CONFIG_PATH = "./src/test/resources/jackrabbitInMemoryTestRepositoryConfig.xml";
    public static final String WORKSPACE_NAME = "default";
    private static Repository repository;
    private Session keepAliveSession;
    protected Credentials simpleCredentials = new SimpleCredentials("jsmith", "secret".toCharArray());

    @BeforeClass
    public static void beforeAll() throws Exception {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() {
        if (repository != null) {
            try {
                JackrabbitRepository jackrabbit = (JackrabbitRepository)repository;
                jackrabbit.shutdown();
            }
            finally {
                repository = null;
                FileUtil.delete((String)JACKRABBIT_DATA_PATH);
            }
        }
    }

    public synchronized void startRepository() throws RepositoryException, IOException {
        if (repository == null) {
            FileUtil.delete((String)JACKRABBIT_DATA_PATH);
            repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
        }
        if (this.keepAliveSession == null) {
            this.keepAliveSession = repository.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public synchronized void shutdownRepository() {
        if (this.keepAliveSession != null) {
            try {
                Logger.getLogger(this.getClass()).debug("Shutting down repository", new Object[0]);
                this.keepAliveSession.logout();
            }
            finally {
                this.keepAliveSession = null;
                if (repository != null) {
                    try {
                        JackrabbitRepository jackrabbit = (JackrabbitRepository)repository;
                        jackrabbit.shutdown();
                    }
                    finally {
                        repository = null;
                        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
                    }
                }
            }
        }
    }

    public boolean isRepositoryStarted() {
        return this.keepAliveSession != null;
    }

    public Repository getRepository() throws RepositoryException, IOException {
        this.startRepository();
        return repository;
    }

    public Credentials getTestCredentials() {
        return this.simpleCredentials;
    }
}

