/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven.spi;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.jcr.SimpleCredentials;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.maven.AbstractJcrRepositoryTest;
import org.jboss.dna.maven.ArtifactType;
import org.jboss.dna.maven.MavenId;
import org.jboss.dna.maven.SignatureType;
import org.jboss.dna.maven.spi.JcrMavenUrlProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JcrMavenUrlProviderTest
extends AbstractJcrRepositoryTest {
    private JcrMavenUrlProvider provider;
    private Properties validProperties;
    private MavenId mavenId1;

    @Before
    public void beforeEach() throws Exception {
        File tmpFolder = new File("target/testdata/tmp");
        tmpFolder.mkdirs();
        System.setProperty("java.io.tmpdir", tmpFolder.getAbsolutePath());
        this.validProperties = new Properties();
        this.validProperties.setProperty("unused.property", "whatever");
        this.validProperties.setProperty("dna.maven.urlprovider.repository.workspace", "default");
        this.validProperties.setProperty("dna.maven.urlprovider.repository.path", "/path/to/repository/root");
        this.validProperties.setProperty("dna.maven.urlprovider.username", "jsmith");
        this.validProperties.setProperty("dna.maven.urlprovider.password", "secret");
        this.mavenId1 = new MavenId("org.jboss.dna", "dna-maven", "1.0-SNAPSHOT");
        this.provider = new JcrMavenUrlProvider();
        this.provider.setRepository(this.getRepository());
    }

    @Test
    public void shouldHaveNullWorkspaceNameUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getWorkspaceName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldHaveNullCredentialsUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getCredentials(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRepositoryPathUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), (Matcher)Is.is((Object)"/dnaMavenRepository"));
    }

    @Test
    public void shouldHaveNonNullPropertiesUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getProperties(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveNonNullPropertiesAfterConfigurationUsingNullProperties() {
        this.provider.configure(null);
        Assert.assertThat((Object)this.provider.getProperties(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveCorrectPropertiesAfterConfiguration() {
        this.provider.configure(this.validProperties);
        Assert.assertThat((Object)this.provider.getProperties(), (Matcher)Is.is((Object)this.validProperties));
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), (Matcher)Is.is((Object)"/path/to/repository/root"));
        Assert.assertThat((Object)this.provider.getCredentials(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)(this.provider.getCredentials() instanceof SimpleCredentials), (Matcher)Is.is((Object)true));
        SimpleCredentials simpleCreds = (SimpleCredentials)this.provider.getCredentials();
        Assert.assertThat((Object)simpleCreds.getUserID(), (Matcher)Is.is((Object)"jsmith"));
        Assert.assertThat((Object)simpleCreds.getPassword(), (Matcher)Is.is((Object)"secret".toCharArray()));
    }

    @Test
    public void shouldNotOverwriteNonDefaultValuesWhenNotGivenInConfigurationProperties() {
        this.provider.configure(this.validProperties);
        this.provider.configure(new Properties());
        Assert.assertThat((Object)this.provider.getProperties(), (Matcher)Is.is((Object)new Properties()));
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), (Matcher)Is.is((Object)"/path/to/repository/root"));
        Assert.assertThat((Object)this.provider.getCredentials(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)(this.provider.getCredentials() instanceof SimpleCredentials), (Matcher)Is.is((Object)true));
        SimpleCredentials simpleCreds = (SimpleCredentials)this.provider.getCredentials();
        Assert.assertThat((Object)simpleCreds.getUserID(), (Matcher)Is.is((Object)"jsmith"));
        Assert.assertThat((Object)simpleCreds.getPassword(), (Matcher)Is.is((Object)"secret".toCharArray()));
    }

    @Test
    public void shouldDetermineProperPathGivenMavenIdAndArtifactType() {
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, null), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.MD5), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.PGP), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, null), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, null), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.MD5), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.PGP), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.SHA1), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, null), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldDeterminePropertPathForMavenIdWithNoArtifactType() {
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, null, null), (Matcher)Is.is((Object)"/org/jboss/dna/dna-maven/1.0-SNAPSHOT/"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdAndArtifactTypeAndSignatureType() throws Exception {
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.MD5, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.PGP, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, null, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, null, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.MD5, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.PGP, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.SHA1, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, null, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdWithNoArtifactType() throws Exception {
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, null, null, false).toString(), (Matcher)Is.is((Object)"jcr://org/jboss/dna/dna-maven/1.0-SNAPSHOT/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnUrlThatCanBeReadFromAndWrittenTo() throws Exception {
        this.startRepository();
        this.provider.configure(this.validProperties);
        String content = "";
        URL url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, true);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        URLConnection connection = url.openConnection();
        OutputStream outputStream = connection.getOutputStream();
        try {
            StringUtil.write((String)content, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        connection = url.openConnection();
        InputStream stream = connection.getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, (Matcher)Is.is((Object)content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        content = "";
        for (int i = 0; i != 100; ++i) {
            content = content + "The old gray mare just ain't what she used to be. Ain't what she used to be. Ain't what she used to be. ";
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, true);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        connection = url.openConnection();
        outputStream = connection.getOutputStream();
        try {
            StringUtil.write((String)content, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        connection = url.openConnection();
        stream = connection.getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, (Matcher)Is.is((Object)content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

