/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.math;

import org.jboss.dna.common.math.DoubleOperations;
import org.junit.Assert;
import org.junit.Test;

public class DoubleOperationsTest {
    private DoubleOperations ops = new DoubleOperations();

    @Test
    public void shouldReturnProperExponenentInScientificNotation() {
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.001)));
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.002)));
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.009999)));
        Assert.assertEquals((long)-2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.01)));
        Assert.assertEquals((long)-2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.02)));
        Assert.assertEquals((long)-2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.09999)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.1)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.2)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.9999)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(0.0)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(1.0)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(2.0)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(9.999)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(10.0)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(20.0)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(99.999)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(100.0)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(200.0)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(999.999)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(1000.0)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(2000.0)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Double.valueOf(9999.999)));
    }

    @Test
    public void shouldRoundNumbersGreaterThan10() {
        Assert.assertEquals((double)101.0, (double)this.ops.roundUp(Double.valueOf(101.2523), 0), (double)0.01);
        Assert.assertEquals((double)101.0, (double)this.ops.roundUp(Double.valueOf(101.2323), 0), (double)0.01);
        Assert.assertEquals((double)101.3, (double)this.ops.roundUp(Double.valueOf(101.2523), 1), (double)0.01);
        Assert.assertEquals((double)101.2, (double)this.ops.roundUp(Double.valueOf(101.2323), 1), (double)0.01);
        Assert.assertEquals((double)110.0, (double)this.ops.roundUp(Double.valueOf(109.2323), -1), (double)1.0);
        Assert.assertEquals((double)100.0, (double)this.ops.roundUp(Double.valueOf(101.2323), -1), (double)1.0);
    }

    @Test
    public void shouldKeepSignificantFigures() {
        Assert.assertEquals((double)12.012, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0123456), 5), (double)1.0E-4);
        Assert.assertEquals((double)12.013, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0125456), 5), (double)1.0E-4);
        Assert.assertEquals((double)12.01, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0123456), 4), (double)1.0E-4);
        Assert.assertEquals((double)12.0, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0123456), 3), (double)1.0E-4);
        Assert.assertEquals((double)12.0, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0123456), 2), (double)1.0E-4);
        Assert.assertEquals((double)10.0, (double)this.ops.keepSignificantFigures(Double.valueOf(12.0123456), 1), (double)1.0E-4);
        Assert.assertEquals((double)1300.0, (double)this.ops.keepSignificantFigures(Double.valueOf(1320.0), 2), (double)0.001);
    }
}

