/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.stats;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.math.FloatOperations;
import org.jboss.dna.common.math.IntegerOperations;
import org.jboss.dna.common.math.MathOperations;
import org.jboss.dna.common.stats.DetailedStatistics;
import org.jboss.dna.common.stats.HistogramTest;
import org.jboss.dna.common.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class DetailedStatisticsTest {
    private DetailedStatistics<Integer> intStats = new DetailedStatistics((MathOperations)new IntegerOperations());
    private DetailedStatistics<Float> floatStats = new DetailedStatistics((MathOperations)new FloatOperations());
    private Logger logger = Logger.getLogger(DetailedStatisticsTest.class);

    @Test
    public void shouldHaveValidValuesWhenUnused() {
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMedian(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getStandardDeviation(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUnusedOnce() {
        this.intStats.add((Number)10);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMedian(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getStandardDeviation(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUsedAnOddNumberOfTimesButMoreThanOnce() {
        this.intStats.add((Number)1);
        this.intStats.add((Number)2);
        this.intStats.add((Number)3);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.0));
        Assert.assertThat((Object)this.intStats.getMedian(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMedianValue(), (Matcher)Is.is((Object)2.0));
        Assert.assertEquals((double)0.816496, (double)this.intStats.getStandardDeviation(), (double)0.001);
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUsedAnEvenNumberOfTimes() {
        this.intStats.add((Number)2);
        this.intStats.add((Number)4);
        this.intStats.add((Number)1);
        this.intStats.add((Number)3);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.5));
        Assert.assertThat((Object)this.intStats.getMedianValue(), (Matcher)Is.is((Object)2.5));
        Assert.assertEquals((double)1.0, (double)this.intStats.getStandardDeviation(), (double)0.2);
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenAllValuesAreTheSame() {
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.0));
        Assert.assertThat((Object)this.intStats.getMedian(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMedianValue(), (Matcher)Is.is((Object)2.0));
        Assert.assertThat((Object)this.intStats.getStandardDeviation(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesForComplexIntegerData() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        this.intStats.add((Number)7);
        this.intStats.add((Number)73);
        this.intStats.add((Number)72);
        this.intStats.add((Number)42);
        this.intStats.add((Number)9);
        this.intStats.add((Number)47);
        this.intStats.add((Number)24);
        System.out.println(this.intStats);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)73));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)32.3));
        Assert.assertEquals((double)32.3, (double)this.intStats.getMeanValue(), (double)1.0E-4);
        Assert.assertEquals((double)22.0, (double)this.intStats.getMedianValue(), (double)1.0E-4);
        Assert.assertEquals((double)23.70675, (double)this.intStats.getStandardDeviation(), (double)1.0E-4);
        HistogramTest.writeHistogramToLog(this.logger, this.intStats.getHistogram(), 20, "Histogram of 10 integer values: ");
        HistogramTest.writeHistogramToLog(this.logger, this.intStats.getHistogram().setBucketCount(7), 20, "Histogram of 10 integer values: ");
    }

    @Test
    public void shouldCorrectStatisitcValuesForComplexFloatData() {
        this.floatStats.add((Number)Float.valueOf(1.9f));
        this.floatStats.add((Number)Float.valueOf(1.0f));
        this.floatStats.add((Number)Float.valueOf(2.0f));
        this.floatStats.add((Number)Float.valueOf(0.7f));
        this.floatStats.add((Number)Float.valueOf(7.3f));
        this.floatStats.add((Number)Float.valueOf(7.2f));
        this.floatStats.add((Number)Float.valueOf(4.2f));
        this.floatStats.add((Number)Float.valueOf(0.9f));
        this.floatStats.add((Number)Float.valueOf(4.7f));
        this.floatStats.add((Number)Float.valueOf(2.4f));
        System.out.println(this.floatStats);
        Assert.assertThat((Object)this.floatStats.getCount(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.floatStats.getMinimum(), (Matcher)Is.is((Object)Float.valueOf(0.7f)));
        Assert.assertThat((Object)this.floatStats.getMaximum(), (Matcher)Is.is((Object)Float.valueOf(7.3f)));
        Assert.assertEquals((double)3.23f, (double)this.floatStats.getMeanValue(), (double)1.0E-4f);
        Assert.assertEquals((double)2.2f, (double)this.floatStats.getMedianValue(), (double)1.0E-4f);
        Assert.assertEquals((double)2.370675f, (double)this.floatStats.getStandardDeviation(), (double)1.0E-4f);
        HistogramTest.writeHistogramToLog(this.logger, this.floatStats.getHistogram(), 20, "Histogram of 10 float values: ");
        HistogramTest.writeHistogramToLog(this.logger, this.floatStats.getHistogram().setBucketCount(7), 20, "Histogram of 10 float values: ");
    }

    @Test
    public void shouldHaveNoStatisticValuesAfterUnusedAndReset() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        Assert.assertEquals((long)3L, (long)this.intStats.getCount());
        this.intStats.reset();
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMedian(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getStandardDeviation(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void shouldHaveStringRepresentationWithoutStatisticsForSingleSample() {
        this.intStats.add((Number)19);
        String str = this.intStats.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("1 sample.*"));
        Assert.assertTrue((boolean)str.matches(".*min=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*max=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*avg=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*stddev=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*median=\\d{1,5}.*"));
    }

    @Test
    public void shouldHaveStringRepresentationWithStatisticsForMultipleSample() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        String str = this.intStats.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("^\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*3 samples.*"));
        Assert.assertTrue((boolean)str.matches(".*min=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*max=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*avg=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*stddev=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*median=\\d{1,5}.*"));
    }
}

