/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.text.NoOpEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NoOpEncoderTest {
    private NoOpEncoder encoder = new NoOpEncoder();

    @Before
    public void beforeEach() {
    }

    protected void checkForNoEncoding(String input) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        String decoded = this.encoder.decode(output);
        Assert.assertEquals((Object)output, (Object)decoded);
        Assert.assertEquals((Object)input, (Object)decoded);
    }

    @Test
    public void shouldReturnNullIfPassedNull() {
        Assert.assertThat((Object)this.encoder.encode(null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.encoder.decode(null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNeverEncodeAnyString() {
        this.checkForNoEncoding("%");
        this.checkForNoEncoding("abcdefghijklmnopqrstuvwxyz");
        this.checkForNoEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.checkForNoEncoding("0123456789");
        this.checkForNoEncoding("-_.!~*'()");
        this.checkForNoEncoding("http://acme.com/this is %something?get=true;something=false");
    }
}

