/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.text.UrlEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UrlEncoderTest {
    private UrlEncoder encoder = new UrlEncoder();

    @Before
    public void beforeEach() {
    }

    protected void checkEncoding(String input, String expected) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)expected, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)expected.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)expected));
        this.checkDecoding(output, input);
    }

    protected void checkForNoEncoding(String input) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
        this.checkDecoding(output, input);
    }

    protected void checkDecoding(String input, String output) {
        String decoded = this.encoder.decode(input);
        Assert.assertEquals((Object)output, (Object)decoded);
        Assert.assertThat((Object)decoded.length(), (Matcher)Is.is((Object)output.length()));
        Assert.assertThat((Object)decoded, (Matcher)Is.is((Object)output));
    }

    @Test
    public void shouldNotEncodeForwardSlashByDefault() {
        this.checkEncoding("/", "%2f");
        this.encoder.setSlashEncoded(false);
        this.checkForNoEncoding("/");
    }

    @Test
    public void shouldEncodePercent() {
        this.checkEncoding("%", "%25");
        this.encoder.setSlashEncoded(false);
        this.checkEncoding("%", "%25");
    }

    @Test
    public void shouldNotEncodeAlphabeticCharacters() {
        this.checkForNoEncoding("abcdefghijklmnopqrstuvwxyz");
        this.checkForNoEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.encoder.setSlashEncoded(false);
        this.checkForNoEncoding("abcdefghijklmnopqrstuvwxyz");
        this.checkForNoEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Test
    public void shouldNotEncodeNumericCharacters() {
        this.checkForNoEncoding("0123456789");
        this.encoder.setSlashEncoded(false);
        this.checkForNoEncoding("0123456789");
    }

    @Test
    public void shouldNotEncodeReservedPunctuationCharacters() {
        this.checkForNoEncoding("-_.!~*'()");
        this.encoder.setSlashEncoded(false);
        this.checkForNoEncoding("-_.!~*'()");
    }

    @Test
    public void shouldNotDecodePercentIfNotFollowedByValidHexNumber() {
        this.checkDecoding("%", "%");
        this.checkDecoding("%2", "%2");
        this.checkDecoding("%2G", "%2G");
        this.checkDecoding("%2f", "/");
        this.checkDecoding("%25", "%");
    }

    @Test
    public void shouldEncodeSpaceUsingHexFormat() {
        this.checkEncoding(" ", "%20");
    }

    @Test
    public void shouldEncodePunctuationUsingHexFormat() {
        this.checkEncoding("`", "%60");
        this.checkEncoding("@", "%40");
        this.checkEncoding("#", "%23");
        this.checkEncoding("$", "%24");
        this.checkEncoding("^", "%5e");
        this.checkEncoding("&", "%26");
        this.checkEncoding("{", "%7b");
        this.checkEncoding("[", "%5b");
        this.checkEncoding("}", "%7d");
        this.checkEncoding("]", "%5d");
        this.checkEncoding("|", "%7c");
        this.checkEncoding(":", "%3a");
        this.checkEncoding(";", "%3b");
        this.checkEncoding("\"", "%22");
        this.checkEncoding("<", "%3c");
        this.checkEncoding(",", "%2c");
        this.checkEncoding(">", "%3e");
        this.checkEncoding("?", "%3f");
    }

    @Test
    public void shouldEncodeAndDecodeUrlsCorrectly() {
        this.encoder.setSlashEncoded(false);
        this.checkEncoding("http://acme.com/this is %something?get=true;something=false", "http%3a//acme.com/this%20is%20%25something%3fget%3dtrue%3bsomething%3dfalse");
    }
}

