/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.util.Base64;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    @Test
    public void testBasicExamples() {
        byte[] originalBytes = new byte[]{-2, -1, 0, 1, 2};
        System.out.println("\n\nOriginal array: ");
        for (int i = 0; i < originalBytes.length; ++i) {
            System.out.print(originalBytes[i] + " ");
        }
        System.out.println();
        String encBytes = Base64.encodeBytes((byte[])originalBytes);
        System.out.println("Bytes, encoded ( " + encBytes.getBytes().length + " bytes):\n" + encBytes);
        byte[] decBytes = Base64.decode((String)encBytes);
        System.out.println("Encoded Bytes -> decoded: ");
        for (int i = 0; i < decBytes.length; ++i) {
            System.out.print(decBytes[i] + " ");
        }
        System.out.println();
    }

    @Test(expected=NullPointerException.class)
    public void testEncodeNullByteArray() {
        Base64.encodeBytes(null);
    }

    @Test
    public void testEncodeEmptyByteArray() {
        String result = Base64.encodeBytes((byte[])new byte[0]);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.length(), (Matcher)Is.is((Object)0));
    }
}

