/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.util.IoUtil;
import org.junit.Assert;
import org.junit.Test;

public class IoUtilTest {
    @Test
    public void readBytesShouldReturnEmptyByteArrayForNullInputStream() throws Exception {
        Assert.assertThat((Object)IoUtil.readBytes((InputStream)null), (Matcher)Is.is((Object)new byte[0]));
    }

    @Test
    public void readBytesShouldReadInputStreamCorrectlyAndShouldCloseStream() throws Exception {
        String content = "This is the way to grandma's house.";
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        InputStreamWrapper wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        byte[] bytes = IoUtil.readBytes((InputStream)wrapper);
        String output = new String(bytes);
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
        for (int i = 0; i != 10; ++i) {
            content = content + content;
        }
        stream = new ByteArrayInputStream(content.getBytes());
        wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        bytes = IoUtil.readBytes((InputStream)wrapper);
        output = new String(bytes);
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void readShouldReturnEmptyStringForNullInputStream() throws Exception {
        Assert.assertThat((Object)IoUtil.read((InputStream)null), (Matcher)Is.is((Object)""));
    }

    @Test
    public void readShouldReturnEmptyStringForNullReader() throws Exception {
        Assert.assertThat((Object)IoUtil.read((Reader)null), (Matcher)Is.is((Object)""));
    }

    @Test
    public void readShouldReadInputStreamCorrectlyAndShouldCloseStream() throws Exception {
        String content = "This is the way to grandma's house.";
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        InputStreamWrapper wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)IoUtil.read((InputStream)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
        for (int i = 0; i != 10; ++i) {
            content = content + content;
        }
        stream = new ByteArrayInputStream(content.getBytes());
        wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)IoUtil.read((InputStream)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void readShouldReadReaderCorrectlyAndShouldCloseStream() throws Exception {
        String content = "This is the way to grandma's house.";
        StringReader reader = new StringReader(content);
        ReaderWrapper wrapper = new ReaderWrapper(reader);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)IoUtil.read((Reader)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
        for (int i = 0; i != 10; ++i) {
            content = content + content;
        }
        reader = new StringReader(content);
        wrapper = new ReaderWrapper(reader);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)IoUtil.read((Reader)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
    }

    protected class WriterWrapper
    extends Writer {
        private boolean closed = false;
        private final Writer writer;

        protected WriterWrapper(Writer writer) {
            this.writer = writer;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() throws IOException {
            this.writer.close();
            this.closed = true;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
        }
    }

    protected class OutputStreamWrapper
    extends OutputStream {
        private boolean closed = false;
        private final OutputStream stream;

        protected OutputStreamWrapper(OutputStream stream) {
            this.stream = stream;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }
    }

    protected class ReaderWrapper
    extends Reader {
        private boolean closed = false;
        private final Reader reader;

        protected ReaderWrapper(Reader reader) {
            this.reader = reader;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() throws IOException {
            this.reader.close();
            this.closed = true;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }
    }

    protected class InputStreamWrapper
    extends InputStream {
        private boolean closed = false;
        private final InputStream stream;

        protected InputStreamWrapper(InputStream stream) {
            this.stream = stream;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }
    }
}

