/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.i18n.I18n;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractI18nTest {
    private Class<?> i18nClass;

    protected AbstractI18nTest(Class<?> i18nClass) {
        this.i18nClass = i18nClass;
    }

    @Test
    public void shouldNotHaveProblems() throws Exception {
        for (Field fld : this.i18nClass.getDeclaredFields()) {
            I18n i18n;
            if (fld.getType() != I18n.class || (fld.getModifiers() & 1) != 1 || (fld.getModifiers() & 8) != 8 || (fld.getModifiers() & 0x10) == 16 || !(i18n = (I18n)fld.get(null)).hasProblem()) continue;
            Assert.fail((String)i18n.problem());
        }
        Set locales = I18n.getLocalizationProblemLocales(this.i18nClass);
        if (!locales.isEmpty()) {
            for (Locale locale : locales) {
                Set problems = I18n.getLocalizationProblems(this.i18nClass, (Locale)locale);
                try {
                    Assert.assertThat((Object)problems.isEmpty(), (Matcher)Is.is((Object)true));
                }
                catch (AssertionError error) {
                    Assert.fail((String)((String)problems.iterator().next()));
                }
            }
        }
    }
}

