/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.collection;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.collection.Problem;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.i18n.I18n;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractProblemsTest {
    private Problems problems;
    private Problem error;
    private Problem warning;
    private Problem info;
    private I18n message;
    private Throwable throwable;
    private String location;
    private String resource;

    @Before
    public void beforeEach() throws Exception {
        this.problems = this.createProblems();
        this.message = CommonI18n.argumentMayNotBeNull;
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, new Object[]{"error msg"}, null, null, null);
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, new Object[]{"warning msg"}, null, null, null);
        this.info = new Problem(Problem.Status.INFO, 1, this.message, new Object[]{"info msg"}, null, null, null);
        this.throwable = new IllegalArgumentException(this.message.text(new Object[]{"throwable"}));
        this.resource = "SomeResource";
        this.location = "/Meaningless/location";
    }

    protected abstract Problems createProblems();

    @Test
    public void shouldBeEmptyImmediatelyAfterInstantiation() {
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAddErrorByMessageAndParametersUsingDefaultCode() {
        this.error = new Problem(Problem.Status.ERROR, 0, this.message, new Object[]{"error msg"}, null, null, null);
        this.problems.addError(this.error.getMessage(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByCodeAndMesssageAndParameters() {
        this.problems.addError(this.error.getCode(), this.error.getMessage(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByThrowableAndMessageAndParametersUsingDefaultCode() {
        this.error = new Problem(Problem.Status.ERROR, 0, this.message, new Object[]{"error msg"}, null, null, this.throwable);
        this.problems.addError(this.error.getThrowable(), this.error.getMessage(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByThrowableAndCodeAndMessageAndParameters() {
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, new Object[]{"error msg"}, null, null, this.throwable);
        this.problems.addError(this.error.getThrowable(), this.error.getCode(), this.error.getMessage(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.error = new Problem(Problem.Status.ERROR, 0, this.message, new Object[]{"error msg"}, this.resource, this.location, null);
        this.problems.addError(this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByCodeAndMesssageAndResourceAndLocationAndParameters() {
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, new Object[]{"error msg"}, this.resource, this.location, null);
        this.problems.addError(this.error.getCode(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByThrowableAndMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.error = new Problem(Problem.Status.ERROR, 0, this.message, new Object[]{"error msg"}, this.resource, this.location, this.throwable);
        this.problems.addError(this.error.getThrowable(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddErrorByThrowableAndCodeAndMessageAndResourceAndLocationAndParameters() {
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, new Object[]{"error msg"}, this.resource, this.location, this.throwable);
        this.problems.addError(this.error.getThrowable(), this.error.getCode(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByMessageAndParametersUsingDefaultCode() {
        this.warning = new Problem(Problem.Status.WARNING, 0, this.message, new Object[]{"warning msg"}, null, null, null);
        this.problems.addWarning(this.warning.getMessage(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByCodeAndMesssageAndParameters() {
        this.problems.addWarning(this.warning.getCode(), this.warning.getMessage(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByThrowableAndMessageAndParametersUsingDefaultCode() {
        this.warning = new Problem(Problem.Status.WARNING, 0, this.message, new Object[]{"warning msg"}, null, null, this.throwable);
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getMessage(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByThrowableAndCodeAndMessageAndParameters() {
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, new Object[]{"warning msg"}, null, null, this.throwable);
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getCode(), this.warning.getMessage(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.warning = new Problem(Problem.Status.WARNING, 0, this.message, new Object[]{"warning msg"}, this.resource, this.location, null);
        this.problems.addWarning(this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByCodeAndMesssageAndResourceAndLocationAndParameters() {
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, new Object[]{"warning msg"}, this.resource, this.location, null);
        this.problems.addWarning(this.warning.getCode(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByThrowableAndMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.warning = new Problem(Problem.Status.WARNING, 0, this.message, new Object[]{"warning msg"}, this.resource, this.location, this.throwable);
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddWarningByThrowableAndCodeAndMessageAndResourceAndLocationAndParameters() {
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, new Object[]{"warning msg"}, this.resource, this.location, this.throwable);
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getCode(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByMessageAndParametersUsingDefaultCode() {
        this.info = new Problem(Problem.Status.INFO, 0, this.message, new Object[]{"info msg"}, null, null, null);
        this.problems.addInfo(this.info.getMessage(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByCodeAndMesssageAndParameters() {
        this.problems.addInfo(this.info.getCode(), this.info.getMessage(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByThrowableAndMessageAndParametersUsingDefaultCode() {
        this.info = new Problem(Problem.Status.INFO, 0, this.message, new Object[]{"info msg"}, null, null, this.throwable);
        this.problems.addInfo(this.info.getThrowable(), this.info.getMessage(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByThrowableAndCodeAndMessageAndParameters() {
        this.info = new Problem(Problem.Status.INFO, 1, this.message, new Object[]{"info msg"}, null, null, this.throwable);
        this.problems.addInfo(this.info.getThrowable(), this.info.getCode(), this.info.getMessage(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.info = new Problem(Problem.Status.INFO, 0, this.message, new Object[]{"info msg"}, this.resource, this.location, null);
        this.problems.addInfo(this.info.getMessage(), this.info.getResource(), this.info.getLocation(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByCodeAndMesssageAndResourceAndLocationAndParameters() {
        this.info = new Problem(Problem.Status.INFO, 1, this.message, new Object[]{"info msg"}, this.resource, this.location, null);
        this.problems.addInfo(this.info.getCode(), this.info.getMessage(), this.info.getResource(), this.info.getLocation(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByThrowableAndMessageAndResourceAndLocationAndParametersUsingDefaultCode() {
        this.info = new Problem(Problem.Status.INFO, 0, this.message, new Object[]{"info msg"}, this.resource, this.location, this.throwable);
        this.problems.addInfo(this.info.getThrowable(), this.info.getMessage(), this.info.getResource(), this.info.getLocation(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddInfoByThrowableAndCodeAndMessageAndResourceAndLocationAndParameters() {
        this.info = new Problem(Problem.Status.INFO, 1, this.message, new Object[]{"info msg"}, this.resource, this.location, this.throwable);
        this.problems.addInfo(this.info.getThrowable(), this.info.getCode(), this.info.getMessage(), this.info.getResource(), this.info.getLocation(), this.info.getParameters());
        Assert.assertThat(this.problems.iterator().next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddProblemsAndMaintainOrder() {
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getCode(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
        this.problems.addError(this.error.getThrowable(), this.error.getCode(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)2));
        this.problems.addInfo(this.info.getThrowable(), this.info.getCode(), this.info.getMessage(), this.info.getResource(), this.info.getLocation(), this.info.getParameters());
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)3));
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getCode(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        this.problems.addError(this.error.getThrowable(), this.error.getCode(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        this.problems.addWarning(this.warning.getThrowable(), this.warning.getCode(), this.warning.getMessage(), this.warning.getResource(), this.warning.getLocation(), this.warning.getParameters());
        this.problems.addError(this.error.getThrowable(), this.error.getCode(), this.error.getMessage(), this.error.getResource(), this.error.getLocation(), this.error.getParameters());
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)7));
        Iterator iter = this.problems.iterator();
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.info));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.warning));
        Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.error));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasWarnings(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.hasInfo(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)false));
    }
}

