/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.collection;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.collection.Problem;
import org.jboss.dna.common.i18n.I18n;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProblemTest {
    private Problem error;
    private Problem warning;
    private Problem info;
    private I18n message;
    private Object[] messageParameters;
    private Throwable throwable;
    private String location;
    private String resource;

    @Before
    public void beforeEach() throws Exception {
        this.message = CommonI18n.argumentMayNotBeNull;
        this.throwable = new IllegalArgumentException(this.message.text(new Object[]{"throwable"}));
        this.messageParameters = new Object[]{"message"};
        this.resource = "SomeResource";
        this.location = "/Meaningless/location";
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
        this.info = new Problem(Problem.Status.INFO, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
    }

    @Test
    public void shouldHaveToString() {
        Assert.assertThat((Object)this.error.toString(), (Matcher)Is.is((Object)("ERROR: (1) " + this.message.text(new Object[]{"message"}) + " Resource=\"" + this.resource + "\" At \"" + this.location + "\" (threw " + this.throwable.getLocalizedMessage() + ")")));
    }

    @Test
    public void shouldHaveToStringWithoutDefaultCode() {
        this.error = new Problem(Problem.Status.ERROR, 0, this.message, new Object[]{"message"}, null, null, null);
        Assert.assertThat((Object)this.error.toString(), (Matcher)Is.is((Object)("ERROR: " + this.message.text(new Object[]{"message"}))));
    }

    @Test
    public void shouldHaveMessageString() {
        this.messageParameters = new Object[]{"error msg"};
        this.error = new Problem(Problem.Status.ERROR, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
        this.messageParameters = new Object[]{"warning msg"};
        this.warning = new Problem(Problem.Status.WARNING, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
        this.messageParameters = new Object[]{"info msg"};
        this.info = new Problem(Problem.Status.INFO, 1, this.message, this.messageParameters, this.resource, this.location, this.throwable);
        Assert.assertThat((Object)this.error.getMessageString(), (Matcher)Is.is((Object)this.message.text(new Object[]{"error msg"})));
        Assert.assertThat((Object)this.warning.getMessageString(), (Matcher)Is.is((Object)this.message.text(new Object[]{"warning msg"})));
        Assert.assertThat((Object)this.info.getMessageString(), (Matcher)Is.is((Object)this.message.text(new Object[]{"info msg"})));
    }
}

