/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.component;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.component.ComponentConfig;
import org.jboss.dna.common.component.ComponentLibrary;
import org.jboss.dna.common.component.MockComponentA;
import org.jboss.dna.common.component.MockComponentB;
import org.jboss.dna.common.component.SampleComponent;
import org.jboss.dna.common.component.SampleComponentConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;

public class ComponentLibraryTest {
    private ComponentLibrary<SampleComponent, SampleComponentConfig> library;
    private SampleComponentConfig configA;
    private SampleComponentConfig configB;
    private SampleComponentConfig configA2;
    private String validDescription;
    private String[] validClasspath;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.library = new ComponentLibrary();
        this.validDescription = "a Component";
        this.validClasspath = new String[]{"com.acme:configA:1.0,com.acme:configB:1.0"};
        this.configA = new SampleComponentConfig("configA", this.validDescription, MockComponentA.class.getName(), this.validClasspath);
        this.configB = new SampleComponentConfig("configB", this.validDescription, MockComponentB.class.getName(), this.validClasspath);
        this.configA2 = new SampleComponentConfig("conFigA", this.validDescription, MockComponentA.class.getName(), this.validClasspath);
    }

    @Test
    public void shouldBeInstantiableWithDefaultConstructor() {
        new ComponentLibrary();
    }

    @Test
    public void shouldHaveDefaultClassLoaderFactory() {
        Assert.assertThat((Object)this.library.getClassLoaderFactory(), (Matcher)Is.is((Object)ComponentLibrary.DEFAULT));
    }

    @Test
    public void shouldSetClassLoaderFactoryToDefaultIfSettingClassLoaderFactoryToNull() {
        this.library.setClassLoaderFactory(null);
        Assert.assertThat((Object)this.library.getClassLoaderFactory(), (Matcher)Is.is((Object)ComponentLibrary.DEFAULT));
    }

    @Test
    public void shouldAddComponentWhenNoneExists() {
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)0));
        this.library.add((ComponentConfig)this.configA);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAddComponentWhenMatchingConfigAlreadyExistsUnlessNotChanged() {
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)0));
        this.library.add((ComponentConfig)this.configA);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((SampleComponent)this.library.getInstances().get(0)).getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)((Object)this.configA))));
        this.library.add((ComponentConfig)this.configA);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((SampleComponent)this.library.getInstances().get(0)).getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)((Object)this.configA))));
        this.library.add((ComponentConfig)this.configA2);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((SampleComponent)this.library.getInstances().get(0)).getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)((Object)this.configA))));
        this.configA2 = new SampleComponentConfig("conFigA", "Config A v2", MockComponentA.class.getName(), this.validClasspath);
        this.library.add((ComponentConfig)this.configA2);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((SampleComponent)this.library.getInstances().get(0)).getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)((Object)this.configA2))));
        this.library.add((ComponentConfig)this.configB);
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((SampleComponent)this.library.getInstances().get(1)).getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)((Object)this.configB))));
    }

    @Test
    public void shouldInstantiateAndConfigureComponentWhenConfigurationAddedOrUpdated() {
        int i;
        Assert.assertThat((Object)this.library.getInstances().size(), (Matcher)Is.is((Object)0));
        this.library.add((ComponentConfig)this.configA);
        List components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)1));
        MockComponentA firstComponent = (MockComponentA)components.get(0);
        Assert.assertThat((Object)firstComponent.isConfigured(), (Matcher)Is.is((Object)true));
        this.library.add((ComponentConfig)this.configA);
        components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        MockComponentA secondComponentA = (MockComponentA)components.get(0);
        Assert.assertThat((Object)secondComponentA.isConfigured(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)secondComponentA, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)firstComponent)));
        this.configA = new SampleComponentConfig("conFigA", "Config A v2", MockComponentA.class.getName(), this.validClasspath);
        this.library.add((ComponentConfig)this.configA);
        components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        secondComponentA = (MockComponentA)components.get(0);
        Assert.assertThat((Object)secondComponentA.isConfigured(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)secondComponentA, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)firstComponent))));
        this.library.add((ComponentConfig)this.configB);
        components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        Assert.assertThat(components.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)secondComponentA)));
        Assert.assertThat(components.get(1), (Matcher)IsInstanceOf.instanceOf(MockComponentB.class));
        MockComponentB firstComponentB = (MockComponentB)components.get(1);
        for (i = 0; i != 10; ++i) {
            firstComponent.doSomething();
        }
        Assert.assertThat((Object)firstComponent.getCounter(), (Matcher)Is.is((Object)10));
        for (i = 0; i != 10; ++i) {
            secondComponentA.doSomething();
        }
        Assert.assertThat((Object)secondComponentA.getCounter(), (Matcher)Is.is((Object)10));
        for (i = 0; i != 10; ++i) {
            firstComponentB.doSomething();
        }
        Assert.assertThat((Object)firstComponentB.getCounter(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void shouldRefreshInstancesWhenCalledDirectly() {
        this.library.add((ComponentConfig)this.configA);
        this.library.add((ComponentConfig)this.configB);
        List components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        Assert.assertThat(components.get(1), (Matcher)IsInstanceOf.instanceOf(MockComponentB.class));
        MockComponentA firstInstanceA = (MockComponentA)components.get(0);
        MockComponentB firstInstanceB = (MockComponentB)components.get(1);
        Assert.assertThat(components.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)firstInstanceA)));
        Assert.assertThat(components.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)firstInstanceB)));
        Assert.assertThat((Object)this.library.refreshInstances(), (Matcher)Is.is((Object)true));
        components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        Assert.assertThat(components.get(1), (Matcher)IsInstanceOf.instanceOf(MockComponentB.class));
        MockComponentA secondInstanceA = (MockComponentA)components.get(0);
        MockComponentB secondInstanceB = (MockComponentB)components.get(1);
        Assert.assertThat(components.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)secondInstanceA)));
        Assert.assertThat(components.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)secondInstanceB)));
        Assert.assertThat((Object)firstInstanceA, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)secondInstanceA))));
        Assert.assertThat((Object)firstInstanceB, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)secondInstanceB))));
    }

    @Test
    public void shouldRefreshInstancesWhenSettingClassLoaderFactory() {
        this.library.add((ComponentConfig)this.configA);
        this.library.add((ComponentConfig)this.configB);
        List components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        Assert.assertThat(components.get(1), (Matcher)IsInstanceOf.instanceOf(MockComponentB.class));
        MockComponentA firstInstanceA = (MockComponentA)components.get(0);
        MockComponentB firstInstanceB = (MockComponentB)components.get(1);
        Assert.assertThat(components.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)firstInstanceA)));
        Assert.assertThat(components.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)firstInstanceB)));
        this.library.setClassLoaderFactory(this.library.getClassLoaderFactory());
        components = this.library.getInstances();
        Assert.assertThat((Object)components.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(components.get(0), (Matcher)IsInstanceOf.instanceOf(MockComponentA.class));
        Assert.assertThat(components.get(1), (Matcher)IsInstanceOf.instanceOf(MockComponentB.class));
        MockComponentA secondInstanceA = (MockComponentA)components.get(0);
        MockComponentB secondInstanceB = (MockComponentB)components.get(1);
        Assert.assertThat(components.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)secondInstanceA)));
        Assert.assertThat(components.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)secondInstanceB)));
        Assert.assertThat((Object)firstInstanceA, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)secondInstanceA))));
        Assert.assertThat((Object)firstInstanceB, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)secondInstanceB))));
    }
}

