/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.math;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.math.LongOperations;
import org.junit.Assert;
import org.junit.Test;

public class LongOperationsTest {
    private LongOperations ops = new LongOperations();

    @Test
    public void shouldReturnProperExponenentInScientificNotation() {
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(0L)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(2L)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(9L)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(10L)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(20L)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(99L)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(100L)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(200L)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(999L)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(1000L)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(2000L)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Long.valueOf(9999L)));
    }

    @Test
    public void shouldRoundUpNumbersGreaterThan10() {
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(-101L), 0), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(-101L), 1), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(-101L), 1), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(-101L), -1), (Matcher)Is.is((Object)-100L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(-109L), -1), (Matcher)Is.is((Object)-110L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(101L), 0), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(101L), 0), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(101L), 1), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(101L), 1), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(109L), -1), (Matcher)Is.is((Object)110L));
        Assert.assertThat((Object)this.ops.roundUp(Long.valueOf(101L), -1), (Matcher)Is.is((Object)100L));
    }

    @Test
    public void shouldRoundDownNumbersGreaterThan10() {
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(-101L), 0), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(-101L), 1), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(-101L), 1), (Matcher)Is.is((Object)-101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(-101L), -1), (Matcher)Is.is((Object)-100L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(-109L), -1), (Matcher)Is.is((Object)-100L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(101L), 0), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(101L), 0), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(101L), 1), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(101L), 1), (Matcher)Is.is((Object)101L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(109L), -1), (Matcher)Is.is((Object)100L));
        Assert.assertThat((Object)this.ops.roundDown(Long.valueOf(101L), -1), (Matcher)Is.is((Object)100L));
    }

    @Test
    public void shouldKeepSignificantFigures() {
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(0L), 2), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201234L), 5), (Matcher)Is.is((Object)1201200L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201254L), 5), (Matcher)Is.is((Object)1201300L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201234L), 4), (Matcher)Is.is((Object)1201000L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201234L), 3), (Matcher)Is.is((Object)1200000L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201234L), 2), (Matcher)Is.is((Object)1200000L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(1201234L), 1), (Matcher)Is.is((Object)1000000L));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Long.valueOf(-1320L), 2), (Matcher)Is.is((Object)-1300L));
    }
}

