/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.statistic;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.number.IsCloseTo;
import org.jboss.dna.common.statistic.Stopwatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StopwatchTest {
    private Stopwatch stopwatch;
    private long totalPauseTimeInMillis;

    @Before
    public void beforeEach() {
        this.stopwatch = new Stopwatch();
    }

    private void pause(int numberOfMilliseconds) {
        try {
            Thread.sleep(numberOfMilliseconds);
            this.totalPauseTimeInMillis += (long)numberOfMilliseconds;
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Error while sleeping for " + numberOfMilliseconds + " milliseconds"));
        }
    }

    @Test
    public void shouldAllowStartingAndStoppingOnce() {
        this.stopwatch.start();
        this.pause(100);
        this.stopwatch.stop();
        Assert.assertEquals((long)1L, (long)this.stopwatch.getCount());
    }

    @Test
    public void shouldAllowStartingAndStoppingMultipleTimes() {
        for (int i = 0; i != 3; ++i) {
            Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
            this.stopwatch.start();
            Assert.assertEquals((Object)true, (Object)this.stopwatch.isRunning());
            this.pause(100);
            this.stopwatch.stop();
            Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
        }
    }

    @Test
    public void shouldKnowWhenItsRunning() {
        Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
        this.stopwatch.start();
        Assert.assertEquals((Object)true, (Object)this.stopwatch.isRunning());
        this.stopwatch.stop();
        Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
    }

    @Test
    public void shouldAllowStopToBeCalledWhenNotRunning() {
        Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
        this.stopwatch.stop();
        this.stopwatch.stop();
        Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
    }

    @Test
    public void shouldAllowStartToBeCalledWhenAlreadyRunning() {
        Assert.assertEquals((Object)false, (Object)this.stopwatch.isRunning());
        this.stopwatch.start();
        Assert.assertEquals((Object)true, (Object)this.stopwatch.isRunning());
        this.stopwatch.start();
        Assert.assertEquals((Object)true, (Object)this.stopwatch.isRunning());
    }

    @Test
    public void shouldReportNumberOfTimesStartedAndStopped() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(10);
            this.stopwatch.stop();
        }
        Assert.assertEquals((long)3L, (long)this.stopwatch.getCount());
    }

    @Test
    public void shouldReportTotalTime() {
        for (int i = 0; i != 4; ++i) {
            this.stopwatch.start();
            this.pause(100);
            this.stopwatch.stop();
        }
        Assert.assertThat((Object)this.stopwatch.getTotalDuration().getDuration(TimeUnit.MILLISECONDS), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)400.0, (double)100.0)));
    }

    @Test
    public void shouldReportAverageTime() {
        for (int i = 0; i != 4; ++i) {
            this.stopwatch.start();
            this.pause(100);
            this.stopwatch.stop();
        }
        Assert.assertThat((Object)this.stopwatch.getAverageDuration().getDuration(TimeUnit.MILLISECONDS), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)100.0, (double)25.0)));
    }

    @Test
    public void shouldReportMinimumTime() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(50 * (i + 1));
            this.stopwatch.stop();
        }
        Assert.assertThat((Object)this.stopwatch.getMinimumDuration().getDuration(TimeUnit.MILLISECONDS), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)50.0, (double)20.0)));
    }

    @Test
    public void shouldReportMaximumTime() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(50 * (i + 1));
            this.stopwatch.stop();
        }
        Assert.assertThat((Object)this.stopwatch.getMaximumDuration().getDuration(TimeUnit.MILLISECONDS), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)150.0, (double)25.0)));
    }

    @Test
    public void shouldReportValidStatisticsEvenBeforeBeingUsed() {
        Assert.assertEquals((long)0L, (long)this.stopwatch.getCount());
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getTotalDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getAverageDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getMinimumDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getMaximumDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
    }

    @Test
    public void shouldReportValidStatisticsAfterBeingReset() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(10 * (i + 1));
            this.stopwatch.stop();
        }
        this.stopwatch.reset();
        Assert.assertEquals((long)0L, (long)this.stopwatch.getCount());
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getTotalDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getAverageDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getMinimumDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)this.stopwatch.getMaximumDuration().getDuration(TimeUnit.SECONDS), (double)1.0E-5);
    }

    @Test
    public void shouldHaveStringRepresentationWithoutStatisticsForSingleSample() {
        this.stopwatch.start();
        this.pause(12);
        this.stopwatch.stop();
        String str = this.stopwatch.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("^\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertFalse((boolean)str.matches(".*1 sample.*"));
        Assert.assertFalse((boolean)str.matches(".*min=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertFalse((boolean)str.matches(".*max=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertFalse((boolean)str.matches(".*avg=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertFalse((boolean)str.matches(".*median=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
    }

    @Test
    public void shouldHaveStringRepresentationWithStatisticsForMultipleSample() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(12);
            this.stopwatch.stop();
        }
        String str = this.stopwatch.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("^\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertTrue((boolean)str.matches(".*3 samples.*"));
        Assert.assertTrue((boolean)str.matches(".*min=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertTrue((boolean)str.matches(".*max=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertTrue((boolean)str.matches(".*avg=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
        Assert.assertTrue((boolean)str.matches(".*median=\\d{2,}:\\d{2}:\\d{2}\\.\\d{3}(,\\d{1,3})?.*"));
    }

    @Test
    public void shouldHaveAHistogramWithZeroSigma() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(12);
            this.stopwatch.stop();
        }
        Assert.assertNotNull((Object)this.stopwatch.getHistogram(0));
    }

    @Test
    public void shouldHaveAHistogramWithOneSigma() {
        for (int i = 0; i != 3; ++i) {
            this.stopwatch.start();
            this.pause(12);
            this.stopwatch.stop();
        }
        Assert.assertNotNull((Object)this.stopwatch.getHistogram(1));
    }
}

