/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.text.Jsr283Encoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Jsr283EncoderTest {
    private Jsr283Encoder encoder = new Jsr283Encoder();

    @Before
    public void beforeEach() {
    }

    protected void checkSingleCharacterEncoding(char input, char expected) {
        String inputString = new String(new char[]{input});
        String output = this.encoder.encode(inputString);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)Character.valueOf(output.charAt(0)), (Matcher)Is.is((Object)Character.valueOf(expected)));
        String decoded = this.encoder.decode(output);
        Assert.assertThat((Object)decoded, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)decoded.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)Character.valueOf(decoded.charAt(0)), (Matcher)Is.is((Object)Character.valueOf(input)));
    }

    protected void checkForNoEncoding(String input) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
        String decoded = this.encoder.decode(output);
        Assert.assertThat((Object)decoded.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)decoded, (Matcher)Is.is((Object)input));
    }

    @Test
    public void shouldEncodeAsterisk() {
        this.checkSingleCharacterEncoding('*', '\uf02a');
    }

    @Test
    public void shouldEncodeForwardSlash() {
        this.checkSingleCharacterEncoding('/', '\uf02f');
    }

    @Test
    public void shouldEncodeColon() {
        this.checkSingleCharacterEncoding(':', '\uf03a');
    }

    @Test
    public void shouldEncodeOpenBracket() {
        this.checkSingleCharacterEncoding('[', '\uf05b');
    }

    @Test
    public void shouldEncodeCloseBracket() {
        this.checkSingleCharacterEncoding(']', '\uf05d');
    }

    @Test
    public void shouldEncodePipe() {
        this.checkSingleCharacterEncoding('|', '\uf07c');
    }

    @Test
    public void shouldNotEncodeAlphabeticCharacters() {
        this.checkForNoEncoding("abcdefghijklmnopqrstuvwxyz");
        this.checkForNoEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Test
    public void shouldNotEncodeNumericCharacters() {
        this.checkForNoEncoding("0123456789");
    }

    @Test
    public void shouldNotEncodePunctuationCharacters() {
        this.checkForNoEncoding("~`!@#$%^&()-_+={}\\;\"'<,>.?");
    }
}

