/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.text.TokenStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokenStreamTest {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 3;
    public static final int SINGLE_QUOTED_STRING = 4;
    public static final int DOUBLE_QUOTED_STRING = 5;
    public static final int COMMENT = 6;
    private TokenStream.Tokenizer tokenizer;
    private String content;
    private TokenStream tokens;

    @Before
    public void beforeEach() {
        this.tokenizer = TokenStream.basicTokenizer((boolean)false);
        this.content = "Select all columns from this table";
        this.makeCaseInsensitive();
    }

    public void makeCaseSensitive() {
        this.tokens = new TokenStream(this.content, this.tokenizer, true);
        this.tokens.start();
    }

    public void makeCaseInsensitive() {
        this.tokens = new TokenStream(this.content, this.tokenizer, false);
        this.tokens.start();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowConsumeBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.consume("Select");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowHasNextBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.hasNext();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowMatchesBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.matches("Select");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowCanConsumeBeforeStartIsCalled() {
        this.tokens = new TokenStream(this.content, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        this.tokens.canConsume("Select");
    }

    @Test
    public void shouldConsumeInCaseSensitiveMannerWithExpectedValuesWhenMatchingExactCase() {
        this.makeCaseSensitive();
        this.tokens.consume("Select");
        this.tokens.consume("all");
        this.tokens.consume("columns");
        this.tokens.consume("from");
        this.tokens.consume("this");
        this.tokens.consume("table");
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=TokenStream.ParsingException.class)
    public void shouldFailToConsumeInCaseSensitiveMannerWithExpectedValuesWhenMatchingIncorrectCase() {
        this.makeCaseSensitive();
        this.tokens.consume("Select");
        this.tokens.consume("all");
        this.tokens.consume("Columns");
    }

    @Test
    public void shouldConsumeInCaseInsensitiveMannerWithExpectedValuesWhenMatchingNonExactCase() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT");
        this.tokens.consume("ALL");
        this.tokens.consume("COLUMNS");
        this.tokens.consume("FROM");
        this.tokens.consume("THIS");
        this.tokens.consume("TABLE");
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=TokenStream.ParsingException.class)
    public void shouldFailToConsumeInCaseInsensitiveMannerWithExpectedValuesWhenMatchingStringIsInLowerCase() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT");
        this.tokens.consume("ALL");
        this.tokens.consume("columns");
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.canConsume("Select"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("all"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("columns"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("from"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("this"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("table"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseSensitiveTokenStreamIfMatchStringDoesNotMatchCaseExactly() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.canConsume("Select"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("all"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("Columns"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("COLUMNS"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("columns"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("from"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("THIS"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("table"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("this"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("table"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseSensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseSensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(6), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(4), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(5), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromMatchesWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.matches("Select"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.matches("select"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("Select"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.matches("all"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("all"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromMatchesWithCaseSensitiveTokenStreamIfMatchStringDoesMatchCaseExactly() {
        this.makeCaseSensitive();
        Assert.assertThat((Object)this.tokens.matches("select"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.matches("SElect"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.matches("Select"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseInsensitiveTokenStreamIfMatchStringIsNotUppercase() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume("Select"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("aLL"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("all"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("ALL"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseInsensitiveTokenStreamIfMatchStringDoesNotMatchCaseExactly() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume("SELECT"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("ALL"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("COLUMNS"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("FROM"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("THIS"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("TABLE"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeWithCaseInsensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnFalseFromCanConsumeWithCaseInsensitiveTokenStreamIfSuppliedTypeDoesMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(6), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(4), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(5), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromMatchesWithCaseInsensitiveTokenStreamIfMatchStringIsUppercaseAndMatches() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.matches("SELECT"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.matches("ALL"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("ALL"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnFalseFromMatchesWithCaseInsensitiveTokenStreamIfMatchStringIsUppercaseAndDoesNotMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.matches("ALL"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.matches("SElect"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.matches("SELECT"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsumeMultipleTokensIfTheyMatch() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE"});
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=TokenStream.ParsingException.class)
    public void shouldFailToConsumeMultipleTokensIfTheyDoNotMatch() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "TABLE"});
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensIfTheyAllMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeArrayOfTokensIfTheyAllMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.matches(new String[]{"SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume(new String[]{"SELECT", "ALL", "COLUMNS", "FROM", "THIS", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensIfTheyDoNotAllMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FRM", "THIS", "TABLE"}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "THIS", "TABLE", "EXTRA"}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "EXTRA", "THIS", "TABLE"}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.canConsume("FROM", new String[]{"THIS", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromMatchAnyOfIfAnyOfTheTokenValuesMatch() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS"}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"}), (Matcher)Is.is((Object)true));
        this.tokens.consume("SELECT");
        Assert.assertThat((Object)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"}), (Matcher)Is.is((Object)true));
        this.tokens.consume("ALL");
        Assert.assertThat((Object)this.tokens.matchesAnyOf("ALL", new String[]{"COLUMNS", "SELECT"}), (Matcher)Is.is((Object)true));
        this.tokens.consume("COLUMNS");
        Assert.assertThat((Object)this.tokens.canConsume("FROM", new String[]{"THIS", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsumeMultipleTokensWithAnyValueConstant() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL", "any value"});
        this.tokens.consume("FROM", new String[]{"THIS", "TABLE"});
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsumeTokenWithAnyValueConstant() {
        this.makeCaseInsensitive();
        this.tokens.consume("SELECT", new String[]{"ALL"});
        this.tokens.consume("any value");
        this.tokens.consume("FROM", new String[]{"THIS", "TABLE"});
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnTrueFromCanConsumeMultipleTokensWithAnyValueConstant() {
        this.makeCaseInsensitive();
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "any value", "FRM", "THIS", "TABLE"}), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.tokens.canConsume("SELECT", new String[]{"ALL", "COLUMNS", "FROM", "any value", "TABLE"}), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.tokens.hasNext(), (Matcher)Is.is((Object)false));
    }
}

