/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoggerTest {
    public static I18n errorMessageWithNoParameters;
    public static I18n warningMessageWithNoParameters;
    public static I18n infoMessageWithNoParameters;
    public static I18n errorMessageWithTwoParameters;
    public static I18n warningMessageWithTwoParameters;
    public static I18n infoMessageWithTwoParameters;
    public static I18n errorMessageWithException;
    public static I18n warningMessageWithException;
    public static I18n infoMessageWithException;
    public static I18n errorMessageWithNullException;
    public static I18n warningMessageWithNullException;
    public static I18n infoMessageWithNullException;
    public static I18n someMessage;
    private LogRecorder log;
    private Logger logger;
    private org.apache.log4j.Logger log4jLogger;
    private Map<String, List<Appender>> existingAppendersByLoggerName = new HashMap<String, List<Appender>>();

    @BeforeClass
    public static void beforeAll() {
        I18n.initialize(LoggerTest.class);
    }

    @Before
    public void beforeEach() {
        this.logger = Logger.getLogger(LoggerTest.class);
        for (org.apache.log4j.Logger theLogger = this.log4jLogger = org.apache.log4j.Logger.getLogger((String)this.logger.getName()); theLogger != null; theLogger = (org.apache.log4j.Logger)theLogger.getParent()) {
            ArrayList<Appender> appenders = new ArrayList<Appender>();
            Enumeration previousAppenders = theLogger.getAllAppenders();
            while (previousAppenders.hasMoreElements()) {
                appenders.add((Appender)previousAppenders.nextElement());
            }
            this.existingAppendersByLoggerName.put(theLogger.getName(), appenders);
            theLogger.removeAllAppenders();
        }
        this.log = new LogRecorder();
        this.log4jLogger = org.apache.log4j.Logger.getLogger((String)this.logger.getName());
        this.log4jLogger.addAppender((Appender)this.log);
        this.log4jLogger.setLevel(Level.ALL);
    }

    @After
    public void afterEach() {
        for (Map.Entry<String, List<Appender>> entry : this.existingAppendersByLoggerName.entrySet()) {
            String loggerName = entry.getKey();
            List<Appender> appenders = entry.getValue();
            org.apache.log4j.Logger theLogger = org.apache.log4j.Logger.getLogger((String)loggerName);
            theLogger.removeAllAppenders();
            for (Appender appender : appenders) {
                theLogger.addAppender(appender);
            }
        }
    }

    @Test
    public void shouldLogAppropriateMessagesIfSetToAllLevel() {
        this.log4jLogger.setLevel(Level.ALL);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with no parameters");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with no parameters");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogAppropriateMessagesIfLog4jSetToTraceLevel() {
        this.log4jLogger.setLevel(Level.TRACE);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with no parameters");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with no parameters");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogAppropriateMessagesIfLog4jSetToDebugLevel() {
        this.log4jLogger.setLevel(Level.DEBUG);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with no parameters");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogAppropriateMessagesIfLog4jSetToInfoLevel() {
        this.log4jLogger.setLevel(Level.INFO);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogAppropriateMessagesIfLog4jSetToWarningLevel() {
        this.log4jLogger.setLevel(Level.WARN);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogAppropriateMessagesIfLog4jSetToErrorLevel() {
        this.log4jLogger.setLevel(Level.ERROR);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldLogNoMessagesIfLog4jSetToOffLevel() {
        this.log4jLogger.setLevel(Level.OFF);
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldNotAcceptMessageWithNonNullAndNullParameters() {
        this.logger.error(errorMessageWithTwoParameters, new Object[]{"first", null});
        this.logger.warn(warningMessageWithTwoParameters, new Object[]{"first", null});
        this.logger.info(infoMessageWithTwoParameters, new Object[]{"first", null});
        this.logger.debug("This is a debug message with a {0} parameter and the {1} parameter", new Object[]{"first", null});
        this.logger.trace("This is a trace message with a {0} parameter and the {1} parameter", new Object[]{"first", null});
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with a first parameter and the null parameter");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with a first parameter and the null parameter");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with a first parameter and the null parameter");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with a first parameter and the null parameter");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with a first parameter and the null parameter");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptErrorMessageWithTooFewParameters() {
        this.logger.error(errorMessageWithTwoParameters, (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptWarningMessageWithTooFewParameters() {
        this.logger.warn(warningMessageWithTwoParameters, (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptInfoMessageWithTooFewParameters() {
        this.logger.info(infoMessageWithTwoParameters, (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptDebugMessageWithTooFewParameters() {
        this.logger.debug("This is a debug message with a {0} parameter and the {1} parameter", (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptTraceMessageWithTooFewParameters() {
        this.logger.trace("This is a trace message with a {0} parameter and the {1} parameter", (Object[])null);
    }

    @Test
    public void shouldAcceptMessageWithNoParameters() {
        this.logger.error(errorMessageWithNoParameters, new Object[0]);
        this.logger.warn(warningMessageWithNoParameters, new Object[0]);
        this.logger.info(infoMessageWithNoParameters, new Object[0]);
        this.logger.debug("This is a debug message with no parameters", new Object[0]);
        this.logger.trace("This is a trace message with no parameters", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with no parameters");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with no parameters");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with no parameters");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with no parameters");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with no parameters");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldAcceptMessageWithObjectAndPrimitiveParameters() {
        this.logger.error(errorMessageWithTwoParameters, new Object[]{"first", 2});
        this.logger.warn(warningMessageWithTwoParameters, new Object[]{"first", 2});
        this.logger.info(infoMessageWithTwoParameters, new Object[]{"first", 2});
        this.logger.debug("This is a debug message with a {0} parameter and the {1} parameter", new Object[]{"first", 2});
        this.logger.trace("This is a trace message with a {0} parameter and the {1} parameter", new Object[]{"first", 2});
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with a first parameter and the 2 parameter");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with a first parameter and the 2 parameter");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with a first parameter and the 2 parameter");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with a first parameter and the 2 parameter");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with a first parameter and the 2 parameter");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldAcceptMessageAndThrowable() {
        RuntimeException t = new RuntimeException("This is the runtime exception message");
        this.logger.error((Throwable)t, errorMessageWithException, new Object[0]);
        this.logger.warn((Throwable)t, warningMessageWithException, new Object[0]);
        this.logger.info((Throwable)t, infoMessageWithException, new Object[0]);
        this.logger.debug((Throwable)t, "This is a debug message with an exception", new Object[0]);
        this.logger.trace((Throwable)t, "This is a trace message with an exception", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with an exception", RuntimeException.class);
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with an exception", RuntimeException.class);
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with an exception", RuntimeException.class);
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with an exception", RuntimeException.class);
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with an exception", RuntimeException.class);
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldAcceptMessageAndNullThrowable() {
        Throwable t = null;
        this.logger.error(t, errorMessageWithNullException, new Object[0]);
        this.logger.warn(t, warningMessageWithNullException, new Object[0]);
        this.logger.info(t, infoMessageWithNullException, new Object[0]);
        this.logger.debug(t, "This is a debug message with a null exception", new Object[0]);
        this.logger.trace(t, "This is a trace message with a null exception", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "This is an error message with a null exception");
        this.log.removeFirst(Logger.Level.WARNING, "This is a warning message with a null exception");
        this.log.removeFirst(Logger.Level.INFO, "This is an info message with a null exception");
        this.log.removeFirst(Logger.Level.DEBUG, "This is a debug message with a null exception");
        this.log.removeFirst(Logger.Level.TRACE, "This is a trace message with a null exception");
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    public void shouldQuietlyAcceptNullMessage() {
        this.logger.error(null, new Object[0]);
        this.logger.warn(null, new Object[0]);
        this.logger.info(null, new Object[0]);
        this.logger.debug(null, new Object[0]);
        this.logger.trace(null, new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldAcceptNullMessageAndThrowable() {
        RuntimeException t = new RuntimeException("This is the runtime exception message in LoggerTest");
        this.logger.error((Throwable)t, null, new Object[0]);
        this.logger.warn((Throwable)t, null, new Object[0]);
        this.logger.info((Throwable)t, null, new Object[0]);
        this.logger.debug((Throwable)t, null, new Object[0]);
        this.logger.trace((Throwable)t, null, new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, null, RuntimeException.class);
        this.log.removeFirst(Logger.Level.WARNING, null, RuntimeException.class);
        this.log.removeFirst(Logger.Level.INFO, null, RuntimeException.class);
        this.log.removeFirst(Logger.Level.DEBUG, null, RuntimeException.class);
        this.log.removeFirst(Logger.Level.TRACE, null, RuntimeException.class);
        Assert.assertEquals((Object)false, (Object)this.log.hasEvents());
    }

    @Test
    public void shouldAcceptNullThrowableInError() {
        this.logger.error((Throwable)null, someMessage, new Object[0]);
        this.logger.warn((Throwable)null, someMessage, new Object[0]);
        this.logger.info((Throwable)null, someMessage, new Object[0]);
        this.logger.debug((Throwable)null, "some message", new Object[0]);
        this.logger.trace((Throwable)null, "some message", new Object[0]);
        this.log.removeFirst(Logger.Level.ERROR, "some message");
        this.log.removeFirst(Logger.Level.WARNING, "some message");
        this.log.removeFirst(Logger.Level.INFO, "some message");
        this.log.removeFirst(Logger.Level.DEBUG, "some message");
        this.log.removeFirst(Logger.Level.TRACE, "some message");
    }

    @Test
    public void shouldSupportAskingWhetherLoggingLevelsAreEnabled() {
        this.logger.isErrorEnabled();
        this.logger.isWarnEnabled();
        this.logger.isInfoEnabled();
        this.logger.isDebugEnabled();
        this.logger.isTraceEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogRecorder
    extends WriterAppender {
        private final LinkedList<LoggingEvent> events;
        private int lineNumber;

        public LogRecorder(StringWriter writer) {
            super((Layout)new SimpleLayout(), (Writer)writer);
            this.events = new LinkedList();
        }

        public LogRecorder() {
            this(new StringWriter());
        }

        protected void subAppend(LoggingEvent event) {
            super.subAppend(event);
            this.events.add(event);
        }

        public LoggingEvent removeFirst() {
            if (this.hasEvents()) {
                ++this.lineNumber;
                return this.events.removeFirst();
            }
            return null;
        }

        public boolean hasEvents() {
            return this.events.size() != 0;
        }

        public void removeFirst(Logger.Level expectedLevel, String expectedMessageExpression, Class<? extends Throwable> expectedExceptionClass) {
            String actual;
            if (!this.hasEvents()) {
                Assert.fail((String)("Expected log message but found none: " + expectedLevel + " - " + expectedMessageExpression));
            }
            LoggingEvent event = this.removeFirst();
            if (expectedMessageExpression != null && event.getMessage() == null) {
                Assert.fail((String)("Log line " + this.lineNumber + " was missing expected message: " + expectedMessageExpression));
            } else if (expectedMessageExpression == null && event.getMessage() != null) {
                Assert.fail((String)("Log line " + this.lineNumber + " had unexpected message: " + event.getMessage()));
            } else if (expectedMessageExpression != null && !(actual = event.getMessage().toString()).matches(expectedMessageExpression)) {
                Assert.fail((String)("Log line " + this.lineNumber + " differed: \nwas     :\t" + actual + "\nexpected:\t" + expectedMessageExpression));
            }
            ThrowableInformation throwableInfo = event.getThrowableInformation();
            if (expectedExceptionClass == null && throwableInfo != null) {
                Assert.fail((String)("Log line " + this.lineNumber + " had unexpected exception: " + event.getThrowableInformation().getThrowableStrRep()));
            } else if (expectedExceptionClass != null && throwableInfo == null) {
                Assert.fail((String)("Log line " + this.lineNumber + " was missing expected exception of type " + expectedExceptionClass.getCanonicalName()));
            } else if (expectedExceptionClass != null && throwableInfo != null) {
                Throwable actualException = throwableInfo.getThrowable();
                Assert.assertSame(expectedExceptionClass, actualException.getClass());
            }
        }

        public void removeFirst(Logger.Level expectedLevel, String expectedMessageExpression) {
            this.removeFirst(expectedLevel, expectedMessageExpression, null);
        }
    }
}

