/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.connector.filesystem.FileSystemSource;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Workspace;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.test.WorkspaceConnectorTest;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemConnectorCreateWorkspacesTest
extends WorkspaceConnectorTest {
    private String pathToRepositories;

    protected RepositorySource setUpSource() throws Exception {
        this.pathToRepositories = "./src/test/resources/repositories/";
        String[] predefinedWorkspaceNames = new String[]{this.pathToRepositories + "airplanes", this.pathToRepositories + "cars"};
        FileSystemSource source = new FileSystemSource();
        source.setName("Test Repository");
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDirectoryForDefaultWorkspace(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    protected String[] generateInvalidNamesForNewWorkspaces() {
        return null;
    }

    protected String[] generateValidNamesForNewWorkspaces() {
        return new String[]{this.pathToRepositories + "trains"};
    }

    @Test
    public void shouldReturnListOfWorkspacesMatchingAbsoluteCanonicalPathsToDirectories() throws IOException {
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : graph.getWorkspaces()) {
            Workspace workspace = graph.useWorkspace(workspaceName);
            workspaceNames.add(workspace.getName());
        }
        String absolutePathToRepositories = new File("./src/test/resources/repositories/").getCanonicalPath();
        absolutePathToRepositories = absolutePathToRepositories + File.separatorChar;
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "airplanes"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "cars"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
        workspaceNames = new HashSet(graph.getWorkspaces());
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "airplanes"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "cars"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
    }
}

