/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.filesystem;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.connector.filesystem.FileSystemSource;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.test.ReadableConnectorTest;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemConnectorReadableTest
extends ReadableConnectorTest {
    protected RepositorySource setUpSource() {
        String path = "./src/test/resources/repositories/";
        String[] predefinedWorkspaceNames = new String[]{path + "airplanes", path + "cars"};
        FileSystemSource source = new FileSystemSource();
        source.setName("Test Repository");
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        return source;
    }

    protected void initializeContent(Graph graph) {
    }

    public void assertThatNodeIsFile(Node node, String mimeType, String contents) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FILE));
        List children = node.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)1));
        Location jcrContentLocation = (Location)children.get(0);
        Assert.assertThat((Object)jcrContentLocation.getPath().getLastSegment().getName(), (Matcher)Is.is((Object)JcrLexicon.CONTENT));
        Node jcrContent = this.graph.getNodeAt(jcrContentLocation);
        Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.MIMETYPE).getFirstValue()), (Matcher)Is.is((Object)mimeType));
        if (contents != null) {
            Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.DATA).getFirstValue()), (Matcher)Is.is((Object)contents));
        }
    }

    public void assertThatNodeIsFolder(Node node) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FOLDER));
    }

    @Test
    public void shouldFindFolderSpecifiedInPathsAsNodesBelowRoot() {
        Node commercial = this.graph.getNodeAt("/commercial");
        this.assertThatNodeIsFolder(commercial);
        Node readme = this.graph.getNodeAt("/commercial/Boeing_777.jpg");
        this.assertThatNodeIsFile(readme, "image/jpeg", null);
    }
}

