/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jdbc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.dbunit.Assertion;
import org.dbunit.IDatabaseTester;
import org.dbunit.JdbcDatabaseTester;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatabaseBasicTest {
    private IDatabaseTester dbTester;

    private IDataSet getDataSet() throws IOException, DataSetException {
        return new FlatXmlDataSet(new File("src/test/data/insert.xml"));
    }

    @Before
    public void beforeEach() throws Exception {
        this.dbTester = new JdbcDatabaseTester("org.hsqldb.jdbcDriver", "jdbc:hsqldb:file:target/testdb/db", "sa", "");
        this.dbTester.setDataSet(this.getDataSet());
        this.dbTester.onSetup();
    }

    @After
    public void afterEach() throws Exception {
        this.dbTester.onTearDown();
    }

    @Test
    public void testTableShallBeLoaded() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("TEST");
        ITable expectedTable = this.getDataSet().getTable("TEST");
        Assertion.assertEquals((ITable)expectedTable, (ITable)actualTable);
    }

    @Test
    public void testTableRecordsLoaded() throws Exception {
        Assert.assertEquals((long)10L, (long)this.dbTester.getConnection().getRowCount("TEST"));
    }

    @Test
    public void testTableRandomRowColumnId() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("TEST");
        Object actualId = actualTable.getValue(4, "ID");
        Assert.assertNotNull((Object)actualId);
        BigDecimal expectedId = new BigDecimal(5);
        Assert.assertTrue((boolean)expectedId.equals(actualId));
    }

    @Test
    public void testTableRandomRowColumnName() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("TEST");
        Assert.assertEquals((Object)"6@hotmail.com", (Object)actualTable.getValue(5, "NAME"));
    }

    @Test
    public void testTableRandomRowColumnDescription() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("TEST");
        Assert.assertEquals((Object)"This is 7", (Object)actualTable.getValue(6, "DESCRIPTION"));
    }

    @Test
    public void testDefaultDatabaseSchemaNameIsEmpty() throws Exception {
        Assert.assertNull((Object)this.dbTester.getConnection().getSchema());
    }

    @Test
    public void salGradeTableShallBeLoaded() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("SALGRADE");
        ITable expectedTable = this.getDataSet().getTable("SALGRADE");
        Assertion.assertEquals((ITable)expectedTable, (ITable)actualTable);
    }

    @Test
    public void deptTableShallBeLoaded() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("DEPT");
        ITable expectedTable = this.getDataSet().getTable("DEPT");
        Assertion.assertEquals((ITable)expectedTable, (ITable)actualTable);
    }

    @Test
    public void empTableShallBeLoaded() throws Exception {
        IDataSet databaseDataSet = this.dbTester.getConnection().createDataSet();
        ITable actualTable = databaseDataSet.getTable("EMP");
        ITable expectedTable = this.getDataSet().getTable("EMP");
        Assert.assertEquals((long)actualTable.getRowCount(), (long)expectedTable.getRowCount());
    }
}

