/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.io.File;
import java.io.IOException;
import org.jboss.dna.common.util.FileUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNConnectorTestUtil {
    public static void main(String[] args) throws Exception {
        try {
            System.out.println("hello ......");
            String svnUrl = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
            String username = "sp";
            String password = "";
            SVNRepository repos = SVNConnectorTestUtil.createRepository(svnUrl, username, password);
            System.out.println("Repository Root: " + repos.getRepositoryRoot(true));
            System.out.println("Repository UUID: " + repos.getRepositoryUUID(true));
            System.out.println("hello ......");
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public static SVNRepository createRepository(String url, String username, String password) throws SVNException {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        repository.setAuthenticationManager(authManager);
        return repository;
    }

    public static String createURL(String src, String dst) throws IOException {
        File mySrc = new File(src);
        File myDst = new File(dst);
        FileUtil.delete((File)myDst);
        FileUtil.copy((File)mySrc, (File)myDst);
        String url = myDst.getCanonicalFile().toURL().toString();
        return url.replaceFirst("file:/", "file://localhost/");
    }

    private SVNConnectorTestUtil() {
    }
}

