/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.text.UrlEncoder;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositoryConnection;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.IsNodeWithChildren;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceListener;
import org.jboss.dna.graph.property.Binary;
import org.jboss.dna.graph.property.DateTimeFactory;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NameFactory;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryConnectionTest {
    private SVNRepositoryConnection connection;
    private ExecutionContext context;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private PropertyFactory propertyFactory;
    private SVNRepository repository;
    private String uuidPropertyName;
    private String sourceName;
    private Graph graph;
    private String svnUrl;
    @MockitoAnnotations.Mock
    private CachePolicy policy;
    @MockitoAnnotations.Mock
    private ReadAllChildrenRequest request;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("dna", "http://www.jboss.org/dna/1.0");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.propertyFactory = this.context.getPropertyFactory();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.svnUrl = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        String username = "sp";
        String password = "";
        this.repository = SVNConnectorTestUtil.createRepository(this.svnUrl, username, password);
        this.sourceName = "the source name";
        this.connection = new SVNRepositoryConnection(this.sourceName, this.policy, Boolean.TRUE.booleanValue(), this.repository);
        this.graph = Graph.create((RepositoryConnection)this.connection, (ExecutionContext)this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInstantiateIfSourceNameIsNull() {
        this.sourceName = null;
        this.connection = new SVNRepositoryConnection(this.sourceName, this.policy, Boolean.FALSE.booleanValue(), this.repository);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInstantiateIfRepositoryIsNull() {
        this.repository = null;
        this.connection = new SVNRepositoryConnection(this.sourceName, this.policy, Boolean.FALSE.booleanValue(), this.repository);
    }

    @Test
    public void shouldInstantiateWithValidSourceAndDAVRepositoryReferences() throws Exception {
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsSourceName() {
        Assert.assertThat((Object)this.connection.getSourceName(), (Matcher)Is.is((Object)"the source name"));
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsDefaultCachePolicy() {
        Assert.assertThat((Object)this.connection.getDefaultCachePolicy(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.policy)));
    }

    @Test
    public void shouldGetTheSVNRepositoryRootFromTheSVNRepositoryWhenPinged() throws Exception {
        CachePolicy policy = (CachePolicy)Mockito.mock(CachePolicy.class);
        this.repository = SVNConnectorTestUtil.createRepository(this.svnUrl, "sp", "");
        this.connection = new SVNRepositoryConnection("the source name", policy, false, this.repository);
        Assert.assertThat((Object)this.connection.ping(1L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveNoOpListenerWhenCreated() {
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SVNRepositoryConnection.NO_OP_LISTENER)));
    }

    @Test
    public void shouldUseNoOpListenerWhenSettingListenerToNull() {
        this.connection.setListener(null);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SVNRepositoryConnection.NO_OP_LISTENER)));
    }

    @Test
    public void shouldSetListenerToNonNullValue() {
        RepositorySourceListener listener = (RepositorySourceListener)Mockito.mock(RepositorySourceListener.class);
        this.connection.setListener(listener);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)listener)));
        this.connection.setListener(null);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SVNRepositoryConnection.NO_OP_LISTENER)));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToGetChildrenFromAWrongRequestedPath() {
        List l = (List)this.graph.getChildren().of((Path)this.pathFactory.create("wrongRequestedPath"));
    }

    @Test
    public void shouldReturnTheContentNodePathOfTheFile() {
        List locations00 = (List)this.graph.getChildren().of((Path)this.pathFactory.create("/nodeA/itemA1.txt"));
        Assert.assertThat((Object)locations00.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.containsPaths(locations00).contains("/nodeA/itemA1.txt/jcr:content"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldListChildrenLocationPathsOfASpecificPath() {
        List l = (List)this.graph.getChildren().of((Path)this.pathFactory.create("/"));
        Assert.assertThat((Object)this.containsPaths(l).contains("/nodeA"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.containsPaths(l).contains("/nodeB"), (Matcher)Is.is((Object)true));
        List locations02 = (List)this.graph.getChildren().of((Path)this.pathFactory.create("/nodeA"));
        Assert.assertThat((Object)(locations02.size() > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.containsPaths(locations02).contains("/nodeA/itemA1.txt/jcr:content"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.containsPaths(locations02).contains("/nodeA/itemA2.txt/jcr:content"), (Matcher)Is.is((Object)true));
        List locations03 = (List)this.graph.getChildren().of((Path)this.pathFactory.create("/nodeB"));
        Assert.assertThat((Object)(locations03.size() > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.containsPaths(locations03).contains("/nodeB/JBossORG-EULA.txt/jcr:content"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.containsPaths(locations03).contains("/nodeB/nodeB1"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotHaveProperties() {
        Location root = Location.create((Path)((Path)this.pathFactory.create("/")));
        Collection nilProperties = (Collection)this.graph.getProperties().on(root);
        Assert.assertThat((Object)nilProperties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nilProperties.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldJustCatchThePropertiesOnLocation() {
        Location nodeA = Location.create((Path)((Path)this.pathFactory.create("/nodeA")));
        Collection nodeAProperties = (Collection)this.graph.getProperties().on(nodeA);
        Assert.assertThat((Object)nodeAProperties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeAProperties.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeAProperties.size(), (Matcher)Is.is((Object)2));
        Location itemA1 = Location.create((Path)((Path)this.pathFactory.create("/nodeA/itemA1.txt")));
        Collection itemA1Properties = (Collection)this.graph.getProperties().on(itemA1);
        Assert.assertThat((Object)itemA1Properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)itemA1Properties.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)itemA1Properties.size(), (Matcher)Is.is((Object)2));
        Location content = Location.create((Path)((Path)this.pathFactory.create("/nodeA/itemA2.txt/jcr:content")));
        Collection itemA2ContentProperties = (Collection)this.graph.getProperties().on(content);
        Assert.assertThat((Object)itemA2ContentProperties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)itemA2ContentProperties.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)itemA2ContentProperties.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldAlwaysReadRootNodeByPath() {
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getLocation().getPath(), (Matcher)Is.is((Object)this.path("/")));
    }

    @Test
    public void shouldAddAndDeleteChildUnderRootNode() throws Exception {
        this.graph.batch().create("/nodeC").with(this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER})).and(this.propertyFactory().create(JcrLexicon.CREATED, new Object[]{this.dateFactory().create(new Date())})).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.child("nodeC")));
        SVNNodeKind nodeCKind = this.repository.checkPath("nodeC", -1L);
        Assert.assertThat((Object)nodeCKind, (Matcher)Is.is((Object)SVNNodeKind.DIR));
        this.graph.batch().create("/nodeC/nodeC_1").with(this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER})).and(this.propertyFactory().create(JcrLexicon.CREATED, new Object[]{this.dateFactory().create(new Date())})).execute();
        Node nodeC = this.graph.getNodeAt("/nodeC");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC.getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.child("nodeC_1")));
        SVNNodeKind nodeC1Kind = this.repository.checkPath("nodeC/nodeC_1", -1L);
        Assert.assertThat((Object)nodeC1Kind, (Matcher)Is.is((Object)SVNNodeKind.DIR));
        byte[] content1 = "My content".getBytes();
        Property jcrDataProperty = this.propertyFactory().create(JcrLexicon.DATA, new Object[]{this.binaryFactory().create(content1)});
        this.graph.batch().create("/nodeC/nodeC_1/file1.txt").with(this.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE})).and(this.propertyFactory().create(JcrLexicon.CREATED, new Object[]{new Date()})).and(jcrDataProperty).execute();
        Node nodeC1 = this.graph.getNodeAt("/nodeC/nodeC_1");
        Assert.assertThat((Object)nodeC1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC1.getChildren().size(), (Matcher)Is.is((Object)1));
        SVNNodeKind fileKind = this.repository.checkPath("/nodeC/nodeC_1/file1.txt", -1L);
        Assert.assertThat((Object)fileKind, (Matcher)Is.is((Object)SVNNodeKind.FILE));
    }

    protected Collection<String> containsPaths(Collection<Location> locations) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Location location : locations) {
            paths.add(location.getPath().getString(this.context.getNamespaceRegistry(), (TextEncoder)new UrlEncoder()));
        }
        return paths;
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected NameFactory nameFactory() {
        return this.context.getValueFactories().getNameFactory();
    }

    protected PathFactory pathFactory() {
        return this.context.getValueFactories().getPathFactory();
    }

    protected PropertyFactory propertyFactory() {
        return this.context.getPropertyFactory();
    }

    protected DateTimeFactory dateFactory() {
        return this.context.getValueFactories().getDateFactory();
    }

    protected ValueFactory<Binary> binaryFactory() {
        return this.context.getValueFactories().getBinaryFactory();
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Property property(String name, Object ... values) {
        Name propName = this.name(name);
        return this.context.getPropertyFactory().create(propName, values);
    }

    protected Path.Segment child(String name) {
        return this.context.getValueFactories().getPathFactory().createSegment(name);
    }
}

