/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositorySource;
import org.jboss.dna.graph.cache.BasicCachePolicy;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SVNRepositorySourceTest {
    private SVNRepositorySource source;
    private RepositoryConnection connection;
    private String validName;
    private String validUuidPropertyName;
    private String url;
    private String username;
    private String password;
    private UUID validRootNodeUuid;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.validName = "svn source";
        this.validUuidPropertyName = "dna:uuid";
        this.url = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        this.validRootNodeUuid = UUID.randomUUID();
        this.source = new SVNRepositorySource();
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldNotSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("name you like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you like"));
        this.source.setName("name you do not like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you do not like"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("something that can change the world");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)Matchers.isNull()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSVNUrl() {
        this.source.setSVNURL(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptySVNUrl() {
        this.source.setSVNURL("");
    }

    @Test
    public void shouldAllowSettingEmptyCredentialsForAnnonymousAccess() {
        this.source.setSVNUsername("");
        Assert.assertThat((Object)this.source.getSVNUsername(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.source.setSVNPassword("");
        Assert.assertThat((Object)this.source.getSVNPassword(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference(this.validName, this.validRootNodeUuid, this.url, this.username, this.password, this.validUuidPropertyName, cachePolicy, 100);
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReferenceWithNullProperties() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference("some source", null, "url1", null, null, null, null, 100);
        this.convertToAndFromJndiReference(null, null, "url2", null, null, null, null, 100);
    }

    private void convertToAndFromJndiReference(String sourceName, UUID rootNodeUuid, String url, String username, String password, String uuidPropertyName, BasicCachePolicy cachePolicy, int retryLimit) throws Exception {
        this.source.setRetryLimit(retryLimit);
        this.source.setName(sourceName);
        this.source.setSVNURL(url);
        this.source.setSVNUsername(username);
        this.source.setSVNPassword(password);
        this.source.setDefaultCachePolicy((CachePolicy)cachePolicy);
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), (Matcher)Is.is((Object)SVNRepositorySource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), (Matcher)Is.is((Object)SVNRepositorySource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        Assert.assertThat((Object)((String)refAttributes.remove("sourceName")), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)((String)refAttributes.remove("svnURL")), (Matcher)Is.is((Object)this.source.getSVNURL()));
        Assert.assertThat((Object)((String)refAttributes.remove("svnUsername")), (Matcher)Is.is((Object)this.source.getSVNUsername()));
        Assert.assertThat((Object)((String)refAttributes.remove("svnPassword")), (Matcher)Is.is((Object)this.source.getSVNPassword()));
        Assert.assertThat((Object)((String)refAttributes.remove("retryLimit")), (Matcher)Is.is((Object)Integer.toString(this.source.getRetryLimit())));
        refAttributes.remove("defaultCachePolicy");
        Assert.assertThat((Object)refAttributes.isEmpty(), (Matcher)Is.is((Object)true));
        SVNRepositorySource factory = new SVNRepositorySource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        SVNRepositorySource recoveredSource = (SVNRepositorySource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getSVNURL(), (Matcher)Is.is((Object)this.source.getSVNURL()));
        Assert.assertThat((Object)recoveredSource.getSVNUsername(), (Matcher)Is.is((Object)this.source.getSVNUsername()));
        Assert.assertThat((Object)recoveredSource.getSVNPassword(), (Matcher)Is.is((Object)this.source.getSVNPassword()));
        Assert.assertThat((Object)recoveredSource.getDefaultCachePolicy(), (Matcher)Is.is((Object)this.source.getDefaultCachePolicy()));
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateFSRepositoryIfProtocolIsOfTypeFile() throws Exception {
        this.source.setName(this.validName);
        this.source.setSVNURL(this.url);
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowMultipleConnectionsToBeOpenAtTheSameTime() throws Exception {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>();
        try {
            for (int i = 0; i != 10; ++i) {
                this.source.setName(this.validName);
                this.source.setSVNURL(this.url);
                RepositoryConnection conn = this.source.getConnection();
                Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                connections.add(conn);
            }
        }
        finally {
            for (RepositoryConnection conn : connections) {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

