/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jboss.dna.common.util.FileUtil;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNConnectorTestUtil {
    public static void main(String[] args) throws Exception {
        try {
            System.out.println("My repos. ......");
            String svnUrl = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
            String username = "sp";
            String password = "";
            System.out.println(svnUrl);
            SVNRepository trunkWorkspace = SVNConnectorTestUtil.createRepository(svnUrl + "/trunk", username, password);
            System.out.println("Repository location: " + trunkWorkspace.getLocation().toString());
            System.out.println("Repository Root: " + trunkWorkspace.getRepositoryRoot(true));
            System.out.println("Repository UUID: " + trunkWorkspace.getRepositoryUUID(true));
            System.out.println("location: " + trunkWorkspace.getLocation().getPath());
            System.out.println("decoded location: " + trunkWorkspace.getLocation().toDecodedString());
            System.out.println("last seg: " + SVNConnectorTestUtil.getRepositoryWorspaceName(trunkWorkspace));
            Collection dirEntries = trunkWorkspace.getDir("", -1L, null, (Collection)null);
            for (SVNDirEntry dirEntry : dirEntries) {
                System.out.println("name: " + dirEntry.getName());
            }
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
    }

    public static SVNRepository createRepository(String url, String username, String password) throws SVNException {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        repository.setAuthenticationManager(authManager);
        return repository;
    }

    public static String createURL(String src, String dst) throws IOException, SVNException {
        File mySrc = new File(src);
        File myDst = new File(dst);
        FileUtil.delete((File)myDst);
        FileUtil.copy((File)mySrc, (File)myDst);
        String url = myDst.getCanonicalFile().toURI().toURL().toExternalForm();
        url = url.replaceFirst("file:/", "file://localhost/");
        SVNURL encodedUrl = SVNURL.parseURIEncoded((String)url);
        url = encodedUrl.toDecodedString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static void listEntries(SVNRepository workspace, String path) throws SVNException {
        Collection entries = workspace.getDir(path, -1L, null, (Collection)null);
        for (SVNDirEntry entry : entries) {
            System.out.println("/" + (path.equals("") ? "" : path + "/") + entry.getName() + " ( author: '" + entry.getAuthor() + "'; revision: " + entry.getRevision() + "; date: " + entry.getDate() + ")");
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            SVNConnectorTestUtil.listEntries(workspace, path.equals("") ? entry.getName() : path + "/" + entry.getName());
        }
    }

    public static String getRepositoryWorspaceName(SVNRepository repository) {
        String[] segments = repository.getLocation().getPath().split("/");
        return segments[segments.length - 1];
    }

    private SVNConnectorTestUtil() {
    }
}

