/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.connector.svn.RepositoryAccessData;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositoryConnection;
import org.jboss.dna.graph.cache.CachePolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNRepositoryConnectionTest {
    private SVNRepositoryConnection connection;
    private SVNRepository selectedRepository;
    private String sourceName;
    private String url;
    String username;
    String password;
    private Set<String> availableWorkspaceNames;
    @MockitoAnnotations.Mock
    private CachePolicy policy;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.url = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        this.username = "sp";
        this.password = "";
        this.selectedRepository = SVNConnectorTestUtil.createRepository(this.url, this.username, this.password);
        this.sourceName = "the source name";
        this.availableWorkspaceNames = new HashSet<String>();
        this.availableWorkspaceNames.add(this.url + "trunk");
        this.availableWorkspaceNames.add(this.url + "tags");
        this.connection = new SVNRepositoryConnection(this.sourceName, this.selectedRepository, this.availableWorkspaceNames, Boolean.FALSE.booleanValue(), this.policy, Boolean.TRUE.booleanValue(), new RepositoryAccessData(this.url, this.username, this.password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInstantiateIfSourceNameIsNull() {
        this.sourceName = null;
        this.connection = new SVNRepositoryConnection(this.sourceName, this.selectedRepository, this.availableWorkspaceNames, Boolean.FALSE.booleanValue(), this.policy, Boolean.FALSE.booleanValue(), new RepositoryAccessData(this.url, this.username, this.password));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInstantiateIfRepositoryIsNull() {
        this.selectedRepository = null;
        this.connection = new SVNRepositoryConnection(this.sourceName, this.selectedRepository, this.availableWorkspaceNames, Boolean.FALSE.booleanValue(), this.policy, Boolean.FALSE.booleanValue(), new RepositoryAccessData(this.url, this.username, this.password));
    }

    @Test
    public void shouldInstantiateWithValidSourceAndDAVRepositoryReferences() throws Exception {
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsSourceName() {
        Assert.assertThat((Object)this.connection.getSourceName(), (Matcher)Is.is((Object)"the source name"));
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsDefaultCachePolicy() {
        Assert.assertThat((Object)this.connection.getDefaultCachePolicy(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.policy)));
    }

    @Test
    public void shouldGetTheSVNRepositoryRootFromTheSVNRepositoryWhenPinged() throws Exception {
        CachePolicy policy = (CachePolicy)Mockito.mock(CachePolicy.class);
        this.selectedRepository = SVNConnectorTestUtil.createRepository(this.url, "sp", "");
        this.connection = new SVNRepositoryConnection("the source name", this.selectedRepository, this.availableWorkspaceNames, Boolean.FALSE.booleanValue(), policy, Boolean.FALSE.booleanValue(), new RepositoryAccessData(this.url, this.username, this.password));
        Assert.assertThat((Object)this.connection.ping(1L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
    }
}

