/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositorySource;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Workspace;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.test.WorkspaceConnectorTest;
import org.junit.Assert;
import org.junit.Test;

public class SVNRepositoryConnectorCreateWorspaceTest
extends WorkspaceConnectorTest {
    private String repositoryRootURL;

    protected RepositorySource setUpSource() throws Exception {
        this.repositoryRootURL = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        String[] predefinedWorkspaceNames = new String[]{this.repositoryRootURL + "trunk", this.repositoryRootURL + "tags"};
        SVNRepositorySource source = new SVNRepositorySource();
        source.setName("Test Repository");
        source.setUsername("sp");
        source.setPassword("");
        source.setRepositoryRootURL(this.repositoryRootURL);
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDirectoryForDefaultWorkspace(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    protected String[] generateInvalidNamesForNewWorkspaces() {
        return null;
    }

    protected String[] generateValidNamesForNewWorkspaces() {
        return new String[]{this.repositoryRootURL + "branches"};
    }

    @Test
    public void shouldReturnListOfWorkspacesMatchingRepositoryURLs() throws Exception {
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : graph.getWorkspaces()) {
            Workspace workspace = graph.useWorkspace(workspaceName);
            workspaceNames.add(workspace.getName());
        }
        Assert.assertThat((Object)workspaceNames.remove(this.repositoryRootURL + "trunk"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.remove(this.repositoryRootURL + "tags"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
        workspaceNames = new HashSet(graph.getWorkspaces());
        Assert.assertThat((Object)workspaceNames.remove(this.repositoryRootURL + "trunk"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.remove(this.repositoryRootURL + "tags"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
    }
}

