/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositorySource;
import org.jboss.dna.graph.cache.BasicCachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SVNRepositorySourceTest {
    private SVNRepositorySource source;
    private RepositoryConnection connection;
    private String validName;
    private String validUuidPropertyName;
    private String repositoryRootURL;
    private String username;
    private String password;
    private UUID validRootNodeUuid;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.repositoryRootURL = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        this.source = new SVNRepositorySource();
        this.source.setName("Test Repository");
        this.source.setUsername("sp");
        this.source.setPassword("");
        this.source.setRepositoryRootURL(this.repositoryRootURL);
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldNotSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        this.source = new SVNRepositorySource();
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("name you like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you like"));
        this.source.setName("name you do not like");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"name you do not like"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("something that can change the world");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)Matchers.isNull()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSVNUrl() {
        this.source.setRepositoryRootURL(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptySVNUrl() {
        this.source.setRepositoryRootURL("");
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)i));
        }
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoName() {
        this.source.setName(null);
        this.source.getConnection();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoUsername() {
        this.source.setUsername(null);
        this.source.getConnection();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoPassword() {
        this.source.setPassword(null);
        this.source.getConnection();
    }

    @Test
    public void shouldCreateConnection() throws Exception {
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference(this.validName, this.validRootNodeUuid, this.repositoryRootURL, this.username, this.password, this.validUuidPropertyName, 100);
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReferenceWithNullProperties() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference("some source", null, "url1", null, null, null, 100);
        this.convertToAndFromJndiReference(null, null, "url2", null, null, null, 100);
    }

    private void convertToAndFromJndiReference(String sourceName, UUID rootNodeUuid, String url, String username, String password, String uuidPropertyName, int retryLimit) throws Exception {
        this.source.setRetryLimit(retryLimit);
        this.source.setName(sourceName);
        this.source.setRepositoryRootURL(url);
        this.source.setUsername(username);
        this.source.setPassword(password);
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), (Matcher)Is.is((Object)SVNRepositorySource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), (Matcher)Is.is((Object)SVNRepositorySource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        Assert.assertThat((Object)((String)refAttributes.remove("sourceName")), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)((String)refAttributes.remove("repositoryRootURL")), (Matcher)Is.is((Object)this.source.getRepositoryRootURL()));
        Assert.assertThat((Object)((String)refAttributes.remove("username")), (Matcher)Is.is((Object)this.source.getUsername()));
        Assert.assertThat((Object)((String)refAttributes.remove("password")), (Matcher)Is.is((Object)this.source.getPassword()));
        Assert.assertThat((Object)((String)refAttributes.remove("retryLimit")), (Matcher)Is.is((Object)Integer.toString(this.source.getRetryLimit())));
        Assert.assertThat((Object)((String)refAttributes.remove("allowCreatingWorkspaces")), (Matcher)Is.is((Object)Boolean.toString(this.source.isCreatingWorkspacesAllowed())));
        Assert.assertThat((Object)((String)refAttributes.remove("cacheTimeToLiveInMilliseconds")), (Matcher)Is.is((Object)Integer.toString(this.source.getCacheTimeToLiveInMilliseconds())));
        Assert.assertThat((Object)((String)refAttributes.remove("defaultWorkspace")), (Matcher)Is.is((Object)this.source.getDirectoryForDefaultWorkspace()));
        refAttributes.remove("predefinedWorkspaceNames");
        Assert.assertThat((Object)refAttributes.isEmpty(), (Matcher)Is.is((Object)true));
        SVNRepositorySource factory = new SVNRepositorySource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        SVNRepositorySource recoveredSource = (SVNRepositorySource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getRepositoryRootURL(), (Matcher)Is.is((Object)this.source.getRepositoryRootURL()));
        Assert.assertThat((Object)recoveredSource.getUsername(), (Matcher)Is.is((Object)this.source.getUsername()));
        Assert.assertThat((Object)recoveredSource.getPassword(), (Matcher)Is.is((Object)this.source.getPassword()));
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowMultipleConnectionsToBeOpenAtTheSameTime() throws Exception {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>();
        try {
            for (int i = 0; i != 10; ++i) {
                RepositoryConnection conn = this.source.getConnection();
                Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                connections.add(conn);
            }
        }
        finally {
            for (RepositoryConnection conn : connections) {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

