/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.connector.svn.SVNConnectorTestUtil;
import org.jboss.dna.connector.svn.SVNRepositorySource;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.test.ReadableConnectorTest;
import org.junit.Assert;
import org.junit.Test;

public class SVNRespositoryConnectorReadableTest
extends ReadableConnectorTest {
    protected RepositorySource setUpSource() throws Exception {
        String repositoryRootURL = SVNConnectorTestUtil.createURL("src/test/resources/dummy_svn_repos", "target/copy_of dummy_svn_repos");
        String[] predefinedWorkspaceNames = new String[]{repositoryRootURL + "trunk", repositoryRootURL + "tags"};
        SVNRepositorySource source = new SVNRepositorySource();
        source.setName("Test Repository");
        source.setUsername("sp");
        source.setPassword("");
        source.setRepositoryRootURL(repositoryRootURL);
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDirectoryForDefaultWorkspace(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(false);
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    @Test
    public void shouldFindFolderSpecifiedInPathsAsNodesBelowRoot() {
        Node root = graph.getNodeAt("/root");
        this.assertThatNodeIsFolder(root);
        Node dnaSubmission = graph.getNodeAt("/root/c/h/JBoss DNA Submission Receipt for JBoss World 2009.pdf");
        this.assertThatNodeIsFile(dnaSubmission, "application/octet-stream", null);
    }

    public void assertThatNodeIsFolder(Node node) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FOLDER));
    }

    public void assertThatNodeIsFile(Node node, String mimeType, String contents) {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), (Matcher)Is.is((Object)JcrNtLexicon.FILE));
        List children = node.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)1));
        Location jcrContentLocation = (Location)children.get(0);
        Assert.assertThat((Object)jcrContentLocation.getPath().getLastSegment().getName(), (Matcher)Is.is((Object)JcrLexicon.CONTENT));
        Node jcrContent = graph.getNodeAt(jcrContentLocation);
        Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.MIMETYPE).getFirstValue()), (Matcher)Is.is((Object)mimeType));
        if (contents != null) {
            Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.DATA).getFirstValue()), (Matcher)Is.is((Object)contents));
        }
    }
}

