/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.connector.svn.RepositoryAccessData;
import org.jboss.dna.connector.svn.SVNRepositoryRequestProcessor;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.request.Request;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryConnection
implements RepositoryConnection {
    private final String sourceName;
    private final CachePolicy cachePolicy;
    private final SVNRepository defaultWorkspace;
    private final boolean updatesAllowed;
    private final Set<String> availableWorkspaceNames;
    private final boolean creatingWorkspacesAllowed;
    private final RepositoryAccessData accessData;

    public SVNRepositoryConnection(String sourceName, SVNRepository defaultWorkspace, Set<String> availableWorkspaceNames, boolean creatingWorkspacesAllowed, CachePolicy cachePolicy, boolean updatesAllowed, RepositoryAccessData accessData) {
        CheckArg.isNotNull((Object)defaultWorkspace, (String)"defaultWorkspace");
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        assert (availableWorkspaceNames != null);
        assert (accessData != null);
        SVNNodeKind nodeKind = null;
        try {
            nodeKind = defaultWorkspace.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)defaultWorkspace.getLocation().getPath());
                throw new SVNException(error);
            }
            if (nodeKind == SVNNodeKind.UNKNOWN) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)defaultWorkspace.getLocation().getPath());
                throw new SVNException(error);
            }
            if (nodeKind == SVNNodeKind.FILE) {
                SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)defaultWorkspace.getLocation().getPath());
                throw new SVNException(error);
            }
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
        this.sourceName = sourceName;
        this.cachePolicy = cachePolicy;
        this.defaultWorkspace = defaultWorkspace;
        this.updatesAllowed = updatesAllowed;
        this.availableWorkspaceNames = availableWorkspaceNames;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.accessData = accessData;
    }

    SVNRepository getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.cachePolicy;
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        try {
            this.defaultWorkspace.getRepositoryRoot(true);
        }
        catch (SVNException e) {
            return false;
        }
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        SVNRepositoryRequestProcessor processor = new SVNRepositoryRequestProcessor(this.sourceName, this.defaultWorkspace, this.availableWorkspaceNames, this.creatingWorkspacesAllowed, context, this.updatesAllowed, this.accessData);
        try {
            processor.process(request);
        }
        finally {
            processor.close();
        }
    }

    public RepositoryAccessData getAccessData() {
        return this.accessData;
    }
}

