/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.connector.scm.ScmAction;
import org.jboss.dna.connector.scm.ScmActionFactory;
import org.jboss.dna.connector.svn.RepositoryAccessData;
import org.jboss.dna.connector.svn.SVNActionExecutor;
import org.jboss.dna.connector.svn.SVNRepositoryConnectorI18n;
import org.jboss.dna.connector.svn.SVNRepositoryUtil;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.Binary;
import org.jboss.dna.graph.property.BinaryFactory;
import org.jboss.dna.graph.property.DateTimeFactory;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NameFactory;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.request.CacheableRequest;
import org.jboss.dna.graph.request.CloneBranchRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.RenameNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryRequestProcessor
extends RequestProcessor
implements ScmActionFactory {
    protected static final String BACK_SLASH = "/";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final String defaultNamespaceUri;
    private final boolean updatesAllowed;
    private SVNRepository defaultWorkspace;
    protected final Logger logger;
    private final Set<String> availableWorkspaceNames;
    private final boolean creatingWorkspacesAllowed;
    private final RepositoryAccessData accessData;

    protected SVNRepositoryRequestProcessor(String sourceName, SVNRepository defaultWorkspace, Set<String> availableWorkspaceNames, boolean creatingWorkspacesAllowed, ExecutionContext context, boolean updatesAllowed, RepositoryAccessData accessData) {
        super(sourceName, context, null);
        assert (defaultWorkspace != null);
        assert (availableWorkspaceNames != null);
        this.defaultNamespaceUri = this.getExecutionContext().getNamespaceRegistry().getDefaultNamespaceUri();
        this.updatesAllowed = updatesAllowed;
        this.defaultWorkspace = defaultWorkspace;
        this.logger = this.getExecutionContext().getLogger(this.getClass());
        this.availableWorkspaceNames = availableWorkspaceNames;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.accessData = accessData;
    }

    protected void addProperty(List<Property> properties, PropertyFactory factory, Name propertyName, Object value) {
        if (value != null) {
            properties.add(factory.create(propertyName, new Object[]{value}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readNode(String workspaceName, Location myLocation, List<Property> properties, List<Location> children, Request request) {
        SVNRepository workspaceRoot = this.getWorkspaceDirectory(workspaceName);
        if (workspaceRoot == null) {
            request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{workspaceName})));
            return false;
        }
        Path requestedPath = this.getPathFor(myLocation, request);
        this.checkThePath(requestedPath, request);
        if (requestedPath.isRoot()) {
            if (children == null) return true;
            Collection<SVNDirEntry> entries = SVNRepositoryUtil.getDir(workspaceRoot, "");
            for (SVNDirEntry entry : entries) {
                String localName = entry.getName();
                Name childName = this.nameFactory().create(this.defaultNamespaceUri, localName);
                Path childPath = this.pathFactory().create(requestedPath, new Name[]{childName});
                children.add(Location.create((Path)childPath));
            }
            return true;
        } else {
            try {
                PropertyFactory factory = this.getExecutionContext().getPropertyFactory();
                DateTimeFactory dateFactory = this.getExecutionContext().getValueFactories().getDateFactory();
                SVNNodeKind kind = this.getNodeKind(workspaceRoot, requestedPath, this.accessData.getRepositoryRootUrl(), workspaceName);
                if (kind == SVNNodeKind.DIR) {
                    String directoryPath = this.getPathAsString(requestedPath);
                    if (!this.accessData.getRepositoryRootUrl().equals(workspaceName)) {
                        directoryPath = directoryPath.substring(1);
                    }
                    if (children != null) {
                        Collection<SVNDirEntry> dirEntries = SVNRepositoryUtil.getDir(workspaceRoot, directoryPath);
                        for (SVNDirEntry entry : dirEntries) {
                            String localName = entry.getName();
                            Name childName = this.nameFactory().create(this.defaultNamespaceUri, localName);
                            Path childPath = this.pathFactory().create(requestedPath, new Name[]{childName});
                            children.add(Location.create((Path)childPath));
                        }
                    }
                    if (properties == null) return true;
                    this.addProperty(properties, factory, JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.FOLDER);
                    SVNDirEntry entry = this.getEntryInfo(workspaceRoot, directoryPath);
                    if (entry == null) return true;
                    this.addProperty(properties, factory, JcrLexicon.LAST_MODIFIED, dateFactory.create(entry.getDate()));
                    return true;
                }
                if (requestedPath.endsWith(JcrLexicon.CONTENT)) {
                    SVNDirEntry entry;
                    if (properties == null) return true;
                    String contentPath = this.getPathAsString(requestedPath.getParent());
                    if (!this.accessData.getRepositoryRootUrl().equals(workspaceName)) {
                        contentPath = contentPath.substring(1);
                    }
                    if ((entry = this.getEntryInfo(workspaceRoot, contentPath)) != null) {
                        this.addProperty(properties, factory, JcrLexicon.PRIMARY_TYPE, DnaLexicon.RESOURCE);
                        this.addProperty(properties, factory, JcrLexicon.LAST_MODIFIED, dateFactory.create(entry.getDate()));
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SVNProperties fileProperties = new SVNProperties();
                    this.getData(contentPath, fileProperties, os);
                    String mimeType = fileProperties.getStringValue("svn:mime-type");
                    if (mimeType == null) {
                        mimeType = DEFAULT_MIME_TYPE;
                    }
                    this.addProperty(properties, factory, JcrLexicon.MIMETYPE, mimeType);
                    if (os.toByteArray().length <= 0) return true;
                    BinaryFactory binaryFactory = this.getExecutionContext().getValueFactories().getBinaryFactory();
                    this.addProperty(properties, factory, JcrLexicon.DATA, binaryFactory.create(os.toByteArray()));
                    return true;
                }
                String filePath = this.getPathAsString(requestedPath);
                if (!this.accessData.getRepositoryRootUrl().equals(workspaceName)) {
                    filePath = filePath.substring(1);
                }
                if (children != null) {
                    Path contentPath = this.pathFactory().create(requestedPath, new Name[]{JcrLexicon.CONTENT});
                    children.add(Location.create((Path)contentPath));
                }
                if (properties == null) return true;
                this.addProperty(properties, factory, JcrLexicon.PRIMARY_TYPE, JcrNtLexicon.FILE);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                SVNProperties fileProperties = new SVNProperties();
                this.getData(filePath, fileProperties, os);
                String created = fileProperties.getStringValue("svn:entry:committed-date");
                this.addProperty(properties, factory, JcrLexicon.CREATED, dateFactory.create(created));
                return true;
            }
            catch (SVNException e) {
                request.setError((Throwable)e);
            }
        }
        return true;
    }

    public void process(ReadNodeRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        LinkedList<Location> children = new LinkedList<Location>();
        LinkedList<Property> properties = new LinkedList<Property>();
        if (this.readNode(request.inWorkspace(), request.at(), properties, children, (Request)request)) {
            request.addChildren(children);
            request.addProperties(properties);
            request.setActualLocationOfNode(request.at());
            this.setCacheableInfo((CacheableRequest)request);
        }
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        LinkedList<Location> children = new LinkedList<Location>();
        if (this.readNode(request.inWorkspace(), request.of(), null, children, (Request)request)) {
            request.addChildren(children);
            request.setActualLocationOfNode(request.of());
            this.setCacheableInfo((CacheableRequest)request);
        }
    }

    public void process(ReadAllPropertiesRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        LinkedList<Property> properties = new LinkedList<Property>();
        if (this.readNode(request.inWorkspace(), request.at(), properties, null, (Request)request)) {
            request.addProperties(properties);
            request.setActualLocationOfNode(request.at());
            this.setCacheableInfo((CacheableRequest)request);
        }
    }

    public void process(CreateNodeRequest request) {
        this.updatesAllowed((Request)request);
    }

    public void process(UpdatePropertiesRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        this.verifyUpdatesAllowed();
    }

    public void process(CopyBranchRequest request) {
        this.updatesAllowed((Request)request);
    }

    public void process(CloneBranchRequest request) {
        this.updatesAllowed((Request)request);
    }

    public void process(DeleteBranchRequest request) {
        this.updatesAllowed((Request)request);
    }

    public void process(MoveBranchRequest request) {
        this.updatesAllowed((Request)request);
    }

    public void process(RenameNodeRequest request) {
        if (this.updatesAllowed((Request)request)) {
            super.process(request);
        }
    }

    public void process(VerifyWorkspaceRequest request) {
        String workspaceName = request.workspaceName();
        if (workspaceName == null) {
            workspaceName = this.defaultWorkspace.getLocation().toDecodedString();
        }
        SVNRepository repository = null;
        if (!this.creatingWorkspacesAllowed) {
            boolean found = false;
            for (String available : this.availableWorkspaceNames) {
                if (workspaceName.equals(available)) {
                    found = true;
                    break;
                }
                repository = SVNRepositoryUtil.createRepository(available, this.accessData.getUsername(), this.accessData.getPassword());
                if (!SVNRepositoryUtil.isDirectory(repository, "") || !repository.getLocation().toDecodedString().equals(workspaceName)) continue;
                found = true;
                break;
            }
            if (!found) {
                request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{workspaceName})));
                return;
            }
        }
        if (SVNRepositoryUtil.isDirectory(repository = SVNRepositoryUtil.createRepository(workspaceName, this.accessData.getUsername(), this.accessData.getPassword()), "")) {
            request.setActualWorkspaceName(repository.getLocation().toDecodedString());
            request.setActualRootLocation(Location.create((Path)this.pathFactory().createRootPath()));
        } else {
            request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{workspaceName})));
        }
    }

    public void process(GetWorkspacesRequest request) {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.availableWorkspaceNames) {
            SVNRepository repos = SVNRepositoryUtil.createRepository(name, this.accessData.getUsername(), this.accessData.getPassword());
            if (repos != null && SVNRepositoryUtil.isDirectory(repos, "")) {
                names.add(repos.getLocation().toDecodedString());
                continue;
            }
            request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{name})));
        }
        request.setAvailableWorkspaceNames(Collections.unmodifiableSet(names));
    }

    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed) {
            request.setError((Throwable)new InvalidRequestException(SVNRepositoryConnectorI18n.sourceDoesNotSupportCloningWorkspaces.text(new Object[]{this.getSourceName()})));
        }
    }

    public void process(CreateWorkspaceRequest request) {
        String workspaceName = request.desiredNameOfNewWorkspace();
        if (!this.creatingWorkspacesAllowed) {
            String msg = SVNRepositoryConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidRequestException(msg));
            return;
        }
        SVNRepository repository = SVNRepositoryUtil.createRepository(workspaceName, this.accessData.getUsername(), this.accessData.getPassword());
        if (SVNRepositoryUtil.isDirectory(repository, "")) {
            request.setActualWorkspaceName(repository.getLocation().toDecodedString());
            request.setActualRootLocation(Location.create((Path)this.pathFactory().createRootPath()));
            this.availableWorkspaceNames.add(repository.getLocation().toDecodedString());
        } else {
            request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{workspaceName})));
        }
    }

    public void process(DestroyWorkspaceRequest request) {
        String workspaceName = request.workspaceName();
        if (!this.creatingWorkspacesAllowed) {
            String msg = SVNRepositoryConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidRequestException(msg));
        }
        if (!this.availableWorkspaceNames.remove(workspaceName)) {
            request.setError((Throwable)new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{workspaceName})));
        }
    }

    protected void verifyUpdatesAllowed() {
        if (!this.updatesAllowed) {
            throw new InvalidRequestException(SVNRepositoryConnectorI18n.sourceIsReadOnly.text(new Object[]{this.getSourceName()}));
        }
    }

    protected boolean updatesAllowed(Request request) {
        if (!this.updatesAllowed) {
            request.setError((Throwable)new InvalidRequestException(SVNRepositoryConnectorI18n.sourceIsReadOnly.text(new Object[]{this.getSourceName()})));
        }
        return !request.hasError();
    }

    protected NameFactory nameFactory() {
        return this.getExecutionContext().getValueFactories().getNameFactory();
    }

    protected PathFactory pathFactory() {
        return this.getExecutionContext().getValueFactories().getPathFactory();
    }

    protected PropertyFactory propertyFactory() {
        return this.getExecutionContext().getPropertyFactory();
    }

    protected DateTimeFactory dateFactory() {
        return this.getExecutionContext().getValueFactories().getDateFactory();
    }

    protected ValueFactory<Binary> binaryFactory() {
        return this.getExecutionContext().getValueFactories().getBinaryFactory();
    }

    protected Path getPathFor(Location location, Request request) {
        Path path = location.getPath();
        if (path == null) {
            I18n msg = SVNRepositoryConnectorI18n.locationInRequestMustHavePath;
            throw new RepositorySourceException(this.getSourceName(), msg.text(new Object[]{this.getSourceName(), request}));
        }
        return path;
    }

    protected void getData(String path, SVNProperties properties, OutputStream os) throws SVNException {
        this.getDefaultWorkspace().getFile(path, -1L, properties, os);
    }

    public SVNRepository getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    protected SVNNodeKind validateNodeKind(SVNRepository repos, Path requestedPath) {
        SVNNodeKind kind;
        String myPath = this.getPathAsString(requestedPath).trim().equals(BACK_SLASH) ? this.getPathAsString(requestedPath) : (requestedPath.endsWith(JcrLexicon.CONTENT) ? this.getPathAsString(requestedPath.getParent()) : this.getPathAsString(requestedPath));
        try {
            kind = repos.checkPath(myPath, -1L);
            if (kind == SVNNodeKind.NONE) {
                throw new PathNotFoundException(Location.create((Path)requestedPath), null, SVNRepositoryConnectorI18n.nodeDoesNotExist.text(new Object[]{myPath}));
            }
            if (kind == SVNNodeKind.UNKNOWN) {
                throw new PathNotFoundException(Location.create((Path)requestedPath), null, SVNRepositoryConnectorI18n.nodeIsActuallyUnknow.text(new Object[]{myPath}));
            }
        }
        catch (SVNException e) {
            throw new RepositorySourceException(this.getSourceName(), SVNRepositoryConnectorI18n.connectingFailureOrUserAuthenticationProblem.text(new Object[]{this.getSourceName()}));
        }
        return kind;
    }

    private String getPathAsString(Path path) {
        return path.getString(this.getExecutionContext().getNamespaceRegistry());
    }

    protected SVNDirEntry getEntryInfo(SVNRepository repos, String path) {
        assert (path != null);
        SVNDirEntry entry = null;
        try {
            entry = repos.info(path, -1L);
        }
        catch (SVNException e) {
            throw new RepositorySourceException(this.getSourceName(), SVNRepositoryConnectorI18n.connectingFailureOrUserAuthenticationProblem.text(new Object[]{this.getSourceName()}));
        }
        return entry;
    }

    protected static void openDirectories(ISVNEditor editor, String rootPath) throws SVNException {
        String dir;
        assert (rootPath != null);
        int pos = rootPath.indexOf(47, 0);
        while (pos != -1) {
            dir = rootPath.substring(0, pos);
            editor.openDir(dir, -1L);
            pos = rootPath.indexOf(47, pos + 1);
        }
        dir = rootPath.substring(0, rootPath.length());
        editor.openDir(dir, -1L);
    }

    protected static void closeDirectories(ISVNEditor editor, String path) throws SVNException {
        int length = path.length() - 1;
        int pos = path.lastIndexOf(47, length);
        editor.closeDir();
        while (pos != -1) {
            editor.closeDir();
            pos = path.lastIndexOf(47, pos - 1);
        }
    }

    public long getLatestRevision(SVNRepository repos) throws Exception {
        try {
            return repos.getLatestRevision();
        }
        catch (SVNException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void addDirEntry(SVNRepository repository, String root, String child, String message) throws SVNException {
        assert (root.trim().length() != 0);
        SVNNodeKind rootKind = repository.checkPath(root, -1L);
        if (rootKind == SVNNodeKind.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is unknown in the repository", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is missing in the repository", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"path with name '{0}' is a file, you need a directory", (Object)root);
            throw new SVNException(err);
        }
        if (rootKind == SVNNodeKind.DIR) {
            ISVNEditor editor = repository.getCommitEditor(message, null, true, null);
            if (root.length() == 1 && root.charAt(0) == '/') {
                this.addProcess(repository, editor, root, "", child);
            } else {
                String rootPath = root.substring(1);
                this.addProcess(repository, editor, rootPath, null, child);
            }
        }
    }

    private void addProcess(SVNRepository repos, ISVNEditor editor, String rootPath, String editedRoot, String childSegmentName) throws SVNException {
        SVNRepositoryRequestProcessor.openDirectories(editor, editedRoot);
        SVNNodeKind childKind = repos.checkPath(childSegmentName, -1L);
        if (childKind == SVNNodeKind.NONE) {
            editor.addDir(childSegmentName, null, -1L);
            SVNRepositoryRequestProcessor.closeDirectories(editor, childSegmentName);
            if (editedRoot != null) {
                SVNRepositoryRequestProcessor.closeDirectories(editor, editedRoot);
            } else {
                SVNRepositoryRequestProcessor.closeDirectories(editor, rootPath);
            }
        } else {
            SVNRepositoryRequestProcessor.closeDirectories(editor, childSegmentName);
            if (editedRoot != null) {
                SVNRepositoryRequestProcessor.closeDirectories(editor, editedRoot);
            } else {
                SVNRepositoryRequestProcessor.closeDirectories(editor, rootPath);
            }
        }
    }

    private void mkdir(SVNRepository repos, String root, String childName, String message) throws SVNException {
        SVNNodeKind childKind = repos.checkPath(childName, -1L);
        if (childKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Item with name '{0}' can't be created", (Object)childName);
            throw new SVNException(err);
        }
        ScmAction addNodeAction = this.addDirectory(root, childName);
        SVNActionExecutor executor = new SVNActionExecutor(repos);
        executor.execute(addNodeAction, message);
    }

    private void newFile(String path, String file, byte[] content, String message) throws SVNException {
        SVNNodeKind childKind = this.defaultWorkspace.checkPath(file, -1L);
        if (childKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Item with name '{0}' can't be created (already exist)", (Object)file);
            throw new SVNException(err);
        }
        ScmAction addFileNodeAction = this.addFile(path, file, content);
        SVNActionExecutor executor = new SVNActionExecutor(this.defaultWorkspace);
        executor.execute(addFileNodeAction, message);
    }

    @Override
    public ScmAction addDirectory(String root, String path) {
        return new AddDirectory(root, path);
    }

    @Override
    public ScmAction addFile(String path, String file, byte[] content) {
        return new AddFile(path, file, content);
    }

    @Override
    public ScmAction copyDirectory(String path, String newPath, long revision) {
        return null;
    }

    @Override
    public ScmAction deleteDirectory(String path) {
        return null;
    }

    @Override
    public ScmAction deleteFile(String path, String file) {
        return null;
    }

    private byte[] getContent(Object[] objs) {
        byte[] content = null;
        for (Object object : objs) {
            if (object == null || !(object instanceof Binary)) continue;
            Binary buf = (Binary)object;
            content = buf.getBytes();
        }
        return content;
    }

    private Object[] values(Collection<Property> childNodeProperties) {
        HashSet<Object> result = new HashSet<Object>();
        for (Property property : childNodeProperties) {
            result.add(property.getFirstValue());
        }
        return result.toArray();
    }

    private void checkThePath(Path path, Request request) {
        for (Path.Segment segment : path) {
            if (segment.getIndex() <= 1) continue;
            I18n msg = SVNRepositoryConnectorI18n.sameNameSiblingsAreNotAllowed;
            throw new RepositorySourceException(this.getSourceName(), msg.text(new Object[]{this.getSourceName(), request}));
        }
    }

    protected SVNRepository getWorkspaceDirectory(String workspaceName) {
        SVNRepository repository = this.defaultWorkspace;
        if (workspaceName != null) {
            SVNRepository repos = SVNRepositoryUtil.createRepository(workspaceName, this.accessData.getUsername(), this.accessData.getPassword());
            if (SVNRepositoryUtil.isDirectory(repos, "")) {
                repository = repos;
            } else {
                return null;
            }
        }
        return repository;
    }

    protected SVNNodeKind getNodeKind(SVNRepository repository, Path path, String repositoryRootUrl, String inWorkspace) throws SVNException {
        SVNNodeKind kind;
        assert (path != null);
        assert (repositoryRootUrl != null);
        assert (inWorkspace != null);
        if (path.endsWith(JcrLexicon.CONTENT)) {
            path = path.getParent();
        }
        String pathAsString = this.getPathAsString(path);
        if (!repositoryRootUrl.equals(inWorkspace)) {
            pathAsString = pathAsString.substring(1);
        }
        if ((kind = repository.checkPath(pathAsString, -1L)) == SVNNodeKind.NONE) {
            throw new PathNotFoundException(Location.create((Path)path), null, SVNRepositoryConnectorI18n.nodeDoesNotExist.text(new Object[]{pathAsString}));
        }
        if (kind == SVNNodeKind.UNKNOWN) {
            throw new PathNotFoundException(Location.create((Path)path), null, SVNRepositoryConnectorI18n.nodeIsActuallyUnknow.text(new Object[]{pathAsString}));
        }
        return kind;
    }

    public static class AddFile
    implements ScmAction {
        private String path;
        private String file;
        private byte[] content;

        public AddFile(String path, String file, byte[] content) {
            this.path = path;
            this.file = file;
            this.content = content;
        }

        public void applyAction(Object context) throws Exception {
            ISVNEditor editor = (ISVNEditor)context;
            SVNRepositoryRequestProcessor.openDirectories(editor, this.path);
            editor.addFile(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, null, -1L);
            editor.applyTextDelta(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, (InputStream)new ByteArrayInputStream(this.content), (ISVNDeltaConsumer)editor, true);
            editor.closeFile(this.path + SVNRepositoryRequestProcessor.BACK_SLASH + this.file, checksum);
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.path);
        }
    }

    public static class AddDirectory
    implements ScmAction {
        private String root;
        private String path;

        public AddDirectory(String root, String path) {
            this.root = root;
            this.path = path;
        }

        public void applyAction(Object context) throws SVNException {
            ISVNEditor editor = (ISVNEditor)context;
            SVNRepositoryRequestProcessor.openDirectories(editor, this.root);
            String[] paths = this.path.split(SVNRepositoryRequestProcessor.BACK_SLASH);
            String newPath = this.root;
            int length = paths.length;
            for (int i = 0; i < length; ++i) {
                newPath = newPath.length() != 0 ? newPath + SVNRepositoryRequestProcessor.BACK_SLASH + paths[i] : paths[i];
                editor.addDir(newPath, null, -1L);
            }
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.path);
            SVNRepositoryRequestProcessor.closeDirectories(editor, this.root);
        }
    }
}

