/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.svn;

import java.util.Collection;
import java.util.Collections;
import org.jboss.dna.connector.svn.SVNRepositoryConnectorI18n;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryUtil {
    public static SVNURL createSVNURL(String url, String sourceName) {
        SVNURL theUrl;
        try {
            theUrl = SVNURL.parseURIDecoded((String)url);
        }
        catch (SVNException e) {
            throw new RepositorySourceException(sourceName, "Protocol is not supported by this connector or there is problem in the svn url");
        }
        return theUrl;
    }

    public static void setNewSVNRepositoryLocation(SVNRepository oldRespository, String url, boolean forceReconnect, String sourceName) {
        try {
            oldRespository.setLocation(SVNRepositoryUtil.createSVNURL(url, sourceName), forceReconnect);
        }
        catch (SVNException e) {
            throw new RepositorySourceException(sourceName, "the old url and a new one has got different protocols");
        }
    }

    public static SVNNodeKind checkThePath(SVNRepository repository, String path, long revisionNumber, String sourceName) {
        SVNNodeKind kind;
        try {
            kind = repository.checkPath(path, revisionNumber);
        }
        catch (SVNException e) {
            throw new RepositorySourceException(sourceName, e.getMessage());
        }
        return kind;
    }

    public static SVNRepository createRepository(String url, String username, String password) {
        SVNRepository repository;
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            repository.setAuthenticationManager(authManager);
        }
        catch (SVNException e) {
            throw new InvalidWorkspaceException(SVNRepositoryConnectorI18n.workspaceDoesNotExist.text(new Object[]{e.getMessage()}));
        }
        return repository;
    }

    public static String getRepositoryWorspaceName(SVNRepository repository) {
        String[] segments = repository.getLocation().getPath().split("/");
        return segments[segments.length - 1];
    }

    private SVNRepositoryUtil() {
    }

    public static boolean exist(SVNRepository repos) {
        try {
            SVNNodeKind kind = repos.checkPath("", -1L);
            return kind != SVNNodeKind.NONE;
        }
        catch (SVNException e) {
            return false;
        }
    }

    public static boolean isDirectory(SVNRepository repos, String path) {
        try {
            SVNNodeKind kind = repos.checkPath(path, -1L);
            if (kind == SVNNodeKind.DIR) {
                return true;
            }
        }
        catch (SVNException e) {
            return false;
        }
        return false;
    }

    public static Collection<SVNDirEntry> getDir(SVNRepository repos, String path) {
        try {
            return repos.getDir(path, -1L, null, (Collection)null);
        }
        catch (SVNException e) {
            return Collections.emptyList();
        }
    }

    public static boolean isFile(SVNRepository repos, String path) {
        try {
            SVNNodeKind kind = repos.checkPath(path, -1L);
            if (kind == SVNNodeKind.FILE) {
                return true;
            }
        }
        catch (SVNException e) {
            return false;
        }
        return false;
    }

    public static boolean exists(SVNRepository repository, String path) {
        try {
            if (repository.checkPath(path, -1L) == SVNNodeKind.NONE) {
                return false;
            }
            if (repository.checkPath(path, -1L) == SVNNodeKind.UNKNOWN) {
                return false;
            }
        }
        catch (SVNException e) {
            return false;
        }
        return true;
    }
}

