/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.tests.integration.jackrabbit;

import java.io.OutputStream;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.i18n.MockI18n;
import org.jboss.dna.common.stats.Histogram;
import org.jboss.dna.common.stats.HistogramTest;
import org.jboss.dna.common.stats.Stopwatch;
import org.jboss.dna.common.util.FileUtil;
import org.jboss.dna.common.util.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JackrabbitInMemoryTest {
    public static final String TESTATA_PATH = "./src/test/resources/";
    public static final String JACKRABBIT_DATA_PATH = "./target/testdata/jackrabbittest/";
    public static final String REPOSITORY_DIRECTORY_PATH = "./target/testdata/jackrabbittest/repository";
    public static final String REPOSITORY_CONFIG_PATH = "./src/test/resources/jackrabbitInMemoryTestRepositoryConfig.xml";
    public static final String USERNAME = "jsmith";
    public static final char[] PASSWORD = "secret".toCharArray();
    private Logger logger;
    private Repository repository;
    private Session session;
    private Stopwatch nodeStopwatch = new Stopwatch();
    private Stopwatch saveStopwatch = new Stopwatch();

    @Before
    public void beforeEach() throws Exception {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        this.logger = Logger.getLogger(JackrabbitInMemoryTest.class);
        this.logger.info(MockI18n.passthrough, new Object[]{"Creating test repository for stress test and logging in with user jsmith"});
        this.repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
        SimpleCredentials creds = new SimpleCredentials(USERNAME, PASSWORD);
        this.session = this.repository.login((Credentials)creds);
        Assert.assertNotNull((Object)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
            FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        }
    }

    public int createNodes(Node parentNode, int numberOfChildNodes, int levelsToCreate) throws Exception {
        int numberCreated = 0;
        for (int i = 0; i < numberOfChildNodes; ++i) {
            this.nodeStopwatch.start();
            Node child = parentNode.addNode("node" + i);
            child.setProperty("jcr:name", "This is the name of node " + i);
            child.setProperty("jcr:description", "This is the description of node " + i);
            this.nodeStopwatch.stop();
            ++numberCreated;
            if (levelsToCreate <= 1) continue;
            numberCreated += this.createNodes(child, numberOfChildNodes, levelsToCreate - 1);
        }
        return numberCreated;
    }

    @Test
    public void shouldCreate10NodesWithNoChildrenAndNoProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 10; ++i) {
            this.nodeStopwatch.start();
            rootNode.addNode("node" + i);
            this.nodeStopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.nodeStopwatch.getHistogram(3).setBucketCount(50), (int)80, (String)"create 100 nodes with no children and no properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.nodeStopwatch.toString()});
    }

    @Test
    public void shouldCreateTreeOfNodes2LevelsDeepWith10ChildrenAtEachNode() throws Exception {
        Node rootNode = this.session.getRootNode();
        Node parent = rootNode.addNode("node");
        int numNodes = this.createNodes(parent, 10, 2);
        this.saveStopwatch.start();
        rootNode.save();
        this.saveStopwatch.stop();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.nodeStopwatch.getHistogram(3).setBucketCount(50), (int)80, (String)("create tree of " + numNodes + " nodes (2 deep, 10 children at every node)"));
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.saveStopwatch.getHistogram(3).setBucketCount(50), (int)80, (String)("1 save of 2x10 tree of " + numNodes + " nodes"));
        this.logger.info(MockI18n.passthrough, new Object[]{"Node operation times: " + this.nodeStopwatch.toString()});
        this.logger.info(MockI18n.passthrough, new Object[]{"Save times: " + this.saveStopwatch.toString()});
    }

    @Test
    public void shouldExportSystemBranchToSystemView() throws Exception {
        this.session.exportSystemView("/jcr:system", (OutputStream)System.out, true, false);
    }

    @Test
    public void shouldExportSystemBranchToDocumentView() throws Exception {
        this.session.exportDocumentView("/jcr:system", (OutputStream)System.out, true, false);
    }

    @Test
    public void shouldNotHaveNamePropertyForNodes() throws Exception {
        Node node = this.session.getRootNode().addNode("test");
        Assert.assertThat((Object)node, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)node.hasProperty("jcr:name"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotHaveUuidPropertyForNonReferenceableNodes() throws Exception {
        Node node = this.session.getRootNode().addNode("test");
        Assert.assertThat((Object)node, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)node.hasProperty("jcr:uuid"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveUuidPropertyForReferenceableNodes() throws Exception {
        Node node = this.session.getRootNode().addNode("test");
        node.addMixin("mix:referenceable");
        Assert.assertThat((Object)node, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)node.hasProperty("jcr:uuid"), (Matcher)Is.is((Object)true));
    }
}

