/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.tests.integration.jackrabbit;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;
import org.jboss.dna.common.i18n.MockI18n;
import org.jboss.dna.common.util.FileUtil;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.tests.integration.jackrabbit.JackrabbitTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JackrabbitBasicFunctionTest {
    public static final String TESTATA_PATH = "./src/test/resources/";
    public static final String JACKRABBIT_DATA_PATH = "./target/testdata/jackrabbittest/";
    public static final String REPOSITORY_DIRECTORY_PATH = "./target/testdata/jackrabbittest/repository";
    public static final String REPOSITORY_CONFIG_PATH = "./src/test/resources/jackrabbitDerbyTestRepositoryConfig.xml";
    public static final String DERBY_SYSTEM_HOME = "./target/testdata/jackrabbittest//derby";
    private Logger logger;
    private Repository repository;

    @Before
    public void beforeEach() throws Exception {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        System.setProperty("derby.system.home", DERBY_SYSTEM_HOME);
        this.logger = Logger.getLogger(JackrabbitBasicFunctionTest.class);
        this.repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
    }

    @After
    public void afterEach() {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConnectWithAnonymous() throws Exception {
        Session session = null;
        try {
            session = this.repository.login();
            Assert.assertNotNull((Object)session);
            String username = session.getUserID();
            String name = this.repository.getDescriptor("jcr.repository.name");
            this.logger.info(MockI18n.passthrough, new Object[]{"Logged in as " + username + " to a " + name + " repository"});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConnectWithSimpleCredentials() throws Exception {
        Session session = null;
        try {
            SimpleCredentials creds = new SimpleCredentials("jsmith", "password".toCharArray());
            session = this.repository.login((Credentials)creds);
            Assert.assertNotNull((Object)session);
            String username = session.getUserID();
            String name = this.repository.getDescriptor("jcr.repository.name");
            this.logger.info(MockI18n.passthrough, new Object[]{"Logged in as " + username + " to a " + name + " repository"});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSupportConcurrentSessionsForDifferentUsers() throws Exception {
        ArrayList<Session> sessions = new ArrayList<Session>();
        try {
            for (int i = 0; i != 10; ++i) {
                SimpleCredentials creds = new SimpleCredentials("user" + i, ("secret" + i).toCharArray());
                Session session = this.repository.login((Credentials)creds);
                Assert.assertNotNull((Object)session);
                sessions.add(session);
                this.logger.info(MockI18n.passthrough, new Object[]{"Logged in as " + session.getUserID()});
            }
        }
        finally {
            while (!sessions.isEmpty()) {
                ((Session)sessions.remove(0)).logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=AccessDeniedException.class)
    public void shouldNotAllowAnonymousUserToCreateContent() throws Exception {
        Session session = null;
        try {
            session = this.repository.login();
            Assert.assertNotNull((Object)session);
            Node root = session.getRootNode();
            Node hello = root.addNode("hello");
            Node world = hello.addNode("world");
            world.setProperty("message", "Hello, World!");
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowAuthenticatedUserToCreateAndManipulateContent() throws Exception {
        Node root;
        SimpleCredentials creds = new SimpleCredentials("user", "secret".toCharArray());
        Session session = null;
        try {
            session = this.repository.login((Credentials)creds);
            Assert.assertNotNull((Object)session);
            root = session.getRootNode();
            Node hello = root.addNode("hello");
            Node world = hello.addNode("world");
            world.setProperty("message", "Hello, World!");
            session.save();
            Node node = root.getNode("hello/world");
            this.logger.info(MockI18n.passthrough, new Object[]{"Node 'hello/world' has path: " + node.getPath()});
            this.logger.info(MockI18n.passthrough, new Object[]{"Node 'hello/world' has 'message' property: " + node.getProperty("message").getString()});
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        try {
            session = this.repository.login((Credentials)creds);
            Assert.assertNotNull((Object)session);
            root = session.getRootNode();
            Node node = root.getNode("hello/world");
            this.logger.info(MockI18n.passthrough, new Object[]{"Node 'hello/world' has path: " + node.getPath()});
            this.logger.info(MockI18n.passthrough, new Object[]{"Node 'hello/world' has 'message' property: " + node.getProperty("message").getString()});
            this.logger.info(MockI18n.passthrough, new Object[]{"Node 'hello' is being removed"});
            root.getNode("hello").remove();
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldImportFile() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("user", "secret".toCharArray());
        Session session = null;
        try {
            session = this.repository.login((Credentials)creds);
            Assert.assertNotNull((Object)session);
            Node root = session.getRootNode();
            if (!root.hasNode("importxml")) {
                System.out.print("Importing xml... ");
                Node node = root.addNode("importxml", "nt:unstructured");
                FileInputStream xml = new FileInputStream("./src/test/resources/jcr-import-test.xml");
                try {
                    session.importXML(node.getPath(), (InputStream)xml, 0);
                }
                finally {
                    xml.close();
                }
                session.save();
                System.out.println("done.");
            }
            JackrabbitTestUtil.dumpNode(root, System.out, true);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

