/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.tests.integration.jackrabbit;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;
import org.jboss.dna.common.i18n.MockI18n;
import org.jboss.dna.common.stats.Histogram;
import org.jboss.dna.common.stats.HistogramTest;
import org.jboss.dna.common.stats.Stopwatch;
import org.jboss.dna.common.util.FileUtil;
import org.jboss.dna.common.util.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JackrabbitDerbyStressTest {
    public static final String TESTATA_PATH = "./src/test/resources/";
    public static final String JACKRABBIT_DATA_PATH = "./target/testdata/jackrabbittest/";
    public static final String REPOSITORY_DIRECTORY_PATH = "./target/testdata/jackrabbittest/repository";
    public static final String REPOSITORY_CONFIG_PATH = "./src/test/resources/jackrabbitDerbyTestRepositoryConfig.xml";
    public static final String DERBY_SYSTEM_HOME = "./target/testdata/jackrabbittest//derby";
    public static final String USERNAME = "jsmith";
    public static final char[] PASSWORD = "secret".toCharArray();
    private Logger logger;
    private Repository repository;
    private Session session;
    private Stopwatch stopwatch = new Stopwatch();

    @Before
    public void beforeEach() throws Exception {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        System.setProperty("derby.system.home", DERBY_SYSTEM_HOME);
        this.logger = Logger.getLogger(JackrabbitDerbyStressTest.class);
        this.logger.info(MockI18n.passthrough, new Object[]{"Creating test repository for stress test and logging in with user jsmith"});
        this.repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
        SimpleCredentials creds = new SimpleCredentials(USERNAME, PASSWORD);
        this.session = this.repository.login((Credentials)creds);
        Assert.assertNotNull((Object)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
            FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        }
    }

    @Test
    public void shouldCreate100NodesWithNoChildrenAndNoProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 100; ++i) {
            this.stopwatch.start();
            rootNode.addNode("node" + i);
            this.stopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.stopwatch.getHistogram(3).setBucketCount(50), (int)80, (String)"create 100 nodes with no children and no properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.stopwatch.toString()});
    }

    @Test
    public void shouldCreate1000NodesWithNoChildrenAndNoProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 1000; ++i) {
            this.stopwatch.start();
            rootNode.addNode("node" + i);
            this.stopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.stopwatch.getHistogram(1).setBucketCount(50), (int)80, (String)"create 1000 nodes with no children and no properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.stopwatch.toString()});
    }

    @Test
    public void shouldCreate5000NodesWithNoChildrenAndNoProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 5000; ++i) {
            this.stopwatch.start();
            rootNode.addNode("node" + i);
            this.stopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.stopwatch.getHistogram(1).setBucketCount(50), (int)80, (String)"create 5000 nodes with no children and no properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.stopwatch.toString()});
    }

    @Test
    public void shouldCreate10000NodesWithNoChildrenAndNoProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 10000; ++i) {
            this.stopwatch.start();
            rootNode.addNode("node" + i);
            this.stopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.stopwatch.getHistogram(1).setBucketCount(50), (int)80, (String)"create 10000 nodes with no children and no properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.stopwatch.toString()});
    }

    @Test
    public void shouldCreate100NodesWithNoChildrenAndSeveralProperties() throws Exception {
        Node rootNode = this.session.getRootNode();
        rootNode.addNode("node");
        for (int i = 0; i != 100; ++i) {
            this.stopwatch.start();
            Node child = rootNode.addNode("node" + i);
            child.setProperty("jcr:name", "This is the name of node " + i);
            child.setProperty("jcr:description", "This is the description of node " + i);
            this.stopwatch.stop();
        }
        rootNode.save();
        HistogramTest.writeHistogramToLog((Logger)this.logger, (Histogram)this.stopwatch.getHistogram(3).setBucketCount(50), (int)80, (String)"create 100 nodes with no children and several properties");
        this.logger.info(MockI18n.passthrough, new Object[]{this.stopwatch.toString()});
    }
}

