/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.tests.integration.jackrabbit;

import java.io.PrintStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class JackrabbitTestUtil {
    public static void dumpNode(Node node, PrintStream stream, boolean recursive) throws RepositoryException {
        System.out.println(node.getPath());
        if (node.getName().equals("jcr:system")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    stream.println(property.getPath() + " = " + values[i].getString());
                }
                continue;
            }
            stream.println(property.getPath() + " = " + property.getString());
        }
        if (recursive) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                JackrabbitTestUtil.dumpNode(nodes.nextNode(), stream, true);
            }
        }
    }
}

