/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.maven.MavenId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MavenIdTest {
    private String validGroupId;
    private String validArtifactId;
    private String validClassifier;
    private String validVersion;
    private String validArtifactIdToString;
    private String validArtifactIdWithNullClassifierToString;
    private MavenId validId;
    private MavenId validIdWithNullClassifier;

    @Before
    public void beforeEach() throws Exception {
        this.validGroupId = "org.jboss.dna";
        this.validArtifactId = "jboss-dna-core";
        this.validClassifier = "jdk1.4";
        this.validVersion = "1.0";
        this.validId = new MavenId(this.validGroupId, this.validArtifactId, this.validVersion, this.validClassifier);
        this.validIdWithNullClassifier = new MavenId(this.validGroupId, this.validArtifactId, this.validVersion, null);
        this.validArtifactIdToString = this.validGroupId + ":" + this.validArtifactId + ":" + this.validVersion + ":" + this.validClassifier;
        this.validArtifactIdWithNullClassifierToString = this.validGroupId + ":" + this.validArtifactId + ":" + this.validVersion + ":";
    }

    @Test
    public void shouldParseValidVersionStringIntoComponents() {
        Assert.assertArrayEquals((Object[])new Object[]{1, 2}, (Object[])MavenId.getVersionComponents((String)"1.2"));
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, 3, 4, 5, 6, 7, 8}, (Object[])MavenId.getVersionComponents((String)"1.2.3.4.5.6.7.8"));
        Assert.assertArrayEquals((Object[])new Object[]{1, 0, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"1.0-SNAPSHOT"));
        Assert.assertArrayEquals((Object[])new Object[]{1, 0, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"1.0,SNAPSHOT"));
        Assert.assertArrayEquals((Object[])new Object[]{1, 0, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"1.0/SNAPSHOT"));
        Assert.assertArrayEquals((Object[])new Object[]{1, 0, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"1.0-SNAPSHOT"));
    }

    @Test
    public void shouldParseEmptyOrNullVersionStringIntoEmptyComponents() {
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])MavenId.getVersionComponents(null));
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])MavenId.getVersionComponents((String)""));
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])MavenId.getVersionComponents((String)"   "));
    }

    @Test
    public void shouldParseVersionStringWithEmbeddedWhitespaceIntoEmptyComponents() {
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"  1.2-SNAPSHOT  "));
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, "SNAPSHOT"}, (Object[])MavenId.getVersionComponents((String)"  1  . 2  -  SNAPSHOT  "));
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, "SNAP SHOT"}, (Object[])MavenId.getVersionComponents((String)"  1  . 2  -  SNAP SHOT  "));
    }

    @Test
    public void shouldCreateInstanceWithValidArguments() {
        new MavenId(this.validGroupId, this.validArtifactId, this.validVersion);
        new MavenId(this.validGroupId, this.validArtifactId, this.validVersion, this.validClassifier);
    }

    @Test
    public void shouldCreateInstanceWithNullOrEmptyVersion() {
        Assert.assertThat((Object)new MavenId(this.validGroupId, this.validArtifactId, null, this.validClassifier), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)new MavenId(this.validGroupId, this.validArtifactId, "", this.validClassifier), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)new MavenId(this.validGroupId, this.validArtifactId, "   ", this.validClassifier), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateInstanceWithNullGroupId() {
        new MavenId(null, this.validArtifactId, this.validVersion, this.validClassifier);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateInstanceWithNullArtifactId() {
        new MavenId(this.validGroupId, null, this.validVersion, this.validClassifier);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateInstanceWithEmptyGroupId() {
        new MavenId("  ", this.validArtifactId, this.validVersion, this.validClassifier);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateInstanceWithEmptyArtifactId() {
        new MavenId(this.validGroupId, "  ", this.validVersion, this.validClassifier);
    }

    @Test
    public void shouldCompareToSelfAsSame() {
        Assert.assertThat((Object)this.validId.compareTo(this.validId), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.validIdWithNullClassifier.compareTo(this.validIdWithNullClassifier), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldEqualSelf() {
        Assert.assertThat((Object)this.validId.equals((Object)this.validId), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.validIdWithNullClassifier.equals((Object)this.validIdWithNullClassifier), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveToStringThatIsCombinationOfAllMembers() {
        Assert.assertThat((Object)this.validId.toString(), (Matcher)Is.is((Object)this.validArtifactIdToString));
        Assert.assertThat((Object)this.validIdWithNullClassifier.toString(), (Matcher)Is.is((Object)this.validArtifactIdWithNullClassifierToString));
    }

    @Test
    public void shouldHaveRepeatableHashCode() {
        int hc = this.validId.hashCode();
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)this.validId.hashCode(), (Matcher)Is.is((Object)hc));
        }
    }

    @Test
    public void shouldAlwaysEqualAnyVersion() {
        MavenId that = this.validId;
        MavenId any = new MavenId(that.getGroupId(), that.getArtifactId(), null, that.getClassifier());
        Assert.assertThat((Object)any.equals((Object)that), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBuildClasspathFromCommaSeparatedCoordinatesIncludingEmptyOrNullValues() {
        Assert.assertThat((Object)MavenId.createClasspath((String)""), (Matcher)Is.is((Object)new MavenId[0]));
        Assert.assertThat((Object)MavenId.createClasspath((String)null), (Matcher)Is.is((Object)new MavenId[0]));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"  org.jboss.dna:dna-maven  "), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"  org.jboss.dna : dna-maven  "), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven:"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven::jdk1.4"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", null, "jdk1.4")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven:1.0:jdk1.4"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven:1.0:jdk1.4,net.jcip:jcip-annotations:1.0"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)"org.jboss.dna:dna-maven:1.0:jdk1.4,,net.jcip:jcip-annotations:1.0,"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
        Assert.assertThat((Object)MavenId.createClasspath((String)",,org.jboss.dna:dna-maven:1.0:jdk1.4,, net.jcip: jcip-annotations:1.0 ,,"), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
    }

    @Test
    public void shouldBuildClasspathFromMultipleCoordinatesIncludingEmptyOrNullValues() {
        Assert.assertThat((Object)MavenId.createClasspath((String[])new String[]{"", "", ""}), (Matcher)Is.is((Object)new MavenId[0]));
        Assert.assertThat((Object)MavenId.createClasspath((String[])null), (Matcher)Is.is((Object)new MavenId[0]));
        Assert.assertThat((Object)MavenId.createClasspath((String[])new String[]{null, null}), (Matcher)Is.is((Object)new MavenId[0]));
        Assert.assertThat((Object)MavenId.createClasspath((String[])new String[]{"org.jboss.dna:dna-maven:1.0:jdk1.4", "net.jcip:jcip-annotations:1.0"}), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
        Assert.assertThat((Object)MavenId.createClasspath((String[])new String[]{"org.jboss.dna:dna-maven:1.0:jdk1.4", "", "net.jcip:jcip-annotations:1.0", ""}), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
        Assert.assertThat((Object)MavenId.createClasspath((String[])new String[]{" org.jboss.dna:dna-maven:1.0:jdk1.4", " net.jcip: jcip-annotations:1.0"}), (Matcher)Is.is((Object)new MavenId[]{new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4"), new MavenId("net.jcip", "jcip-annotations", "1.0")}));
    }

    @Test
    public void shouldBuildClasspathFromMavenIdsAndRemoveDuplicatesAndNulls() {
        MavenId id1 = new MavenId("org.jboss.dna", "dna-maven", "1.0", "jdk1.4");
        MavenId id2 = new MavenId("org.jboss.dna", "dna-maven", "1.0");
        Assert.assertThat((Object)MavenId.createClasspath((MavenId[])new MavenId[]{id1, null, id2, id1, id2, null}), (Matcher)Is.is((Object)new MavenId[]{id1, id2}));
    }
}

