/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.graph.sequencer.MockSequencerContext;
import org.jboss.dna.graph.sequencer.MockSequencerOutput;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;
import org.jboss.dna.sequencer.classfile.ClassFileRecorder;
import org.jboss.dna.sequencer.classfile.ClassFileSequencer;
import org.jboss.dna.sequencer.classfile.metadata.ClassMetadata;
import org.jboss.dna.sequencer.classfile.metadata.EnumMetadata;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassFileSequencerTest {
    private ClassFileSequencer sequencer;
    private InputStream input;
    private MockSequencerOutput output;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() throws Exception {
        this.sequencer = new ClassFileSequencer();
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("class", "http://www.jboss.org/dna/sequencer/classfile/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.output = new MockSequencerOutput(this.context);
        this.input = this.getClass().getResourceAsStream("/NodeEntity.clazz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }

    @Test
    public void shouldAllowSettingClassFileRecorder() throws Exception {
        MockClassFileRecorder recorder = new MockClassFileRecorder();
        MockClassFileRecorder.called = false;
        this.sequencer.setClassFileRecorder((ClassFileRecorder)recorder);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockClassFileRecorder.called, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingClassFileRecorderByName() throws Exception {
        MockClassFileRecorder.called = false;
        this.sequencer.setClassFileRecorderClassName(MockClassFileRecorder.class.getName());
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockClassFileRecorder.called, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingClassFileRecorderToDefaultByName() throws Exception {
        MockClassFileRecorder.called = false;
        this.sequencer.setClassFileRecorderClassName(MockClassFileRecorder.class.getName());
        this.sequencer.setClassFileRecorderClassName(null);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockClassFileRecorder.called, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowSettingClassFileRecorderToDefault() throws Exception {
        MockClassFileRecorder.called = false;
        this.sequencer.setClassFileRecorder((ClassFileRecorder)new MockClassFileRecorder());
        this.sequencer.setClassFileRecorder(null);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockClassFileRecorder.called, (Matcher)Is.is((Object)false));
    }

    @Test(expected=ClassCastException.class)
    public void shouldNotAllowSettingClassFileRecorderToInvalidClass() throws Exception {
        this.sequencer.setClassFileRecorderClassName(Object.class.getName());
    }

    public static class MockClassFileRecorder
    implements ClassFileRecorder {
        static boolean called = false;

        public void recordClass(StreamSequencerContext context, SequencerOutput output, ClassMetadata classMetadata) {
            called = true;
        }

        public void recordEnum(StreamSequencerContext context, SequencerOutput output, EnumMetadata enumMetadata) {
        }
    }
}

