/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.property.DateTimeFactory;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;
import org.jboss.dna.sequencer.classfile.ClassFileRecorder;
import org.jboss.dna.sequencer.classfile.ClassFileSequencerLexicon;
import org.jboss.dna.sequencer.classfile.metadata.AnnotationMetadata;
import org.jboss.dna.sequencer.classfile.metadata.ClassMetadata;
import org.jboss.dna.sequencer.classfile.metadata.EnumMetadata;
import org.jboss.dna.sequencer.classfile.metadata.FieldMetadata;
import org.jboss.dna.sequencer.classfile.metadata.MethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassFileRecorder
implements ClassFileRecorder {
    @Override
    public void recordClass(StreamSequencerContext context, SequencerOutput output, ClassMetadata classMetadata) {
        PathFactory pathFactory = this.pathFactoryFor(context);
        DateTimeFactory dateFactory = this.dateFactoryFor(context);
        Path classPath = this.pathFor(pathFactory, classMetadata);
        this.writeClassNode(output, pathFactory, dateFactory, classPath, classMetadata);
    }

    private DateTimeFactory dateFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getDateFactory();
    }

    private PathFactory pathFactoryFor(StreamSequencerContext context) {
        return context.getValueFactories().getPathFactory();
    }

    private Path pathFor(PathFactory pathFactory, ClassMetadata cmd) {
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        for (String segment : cmd.getClassName().split("\\.")) {
            segments.add(pathFactory.createSegment(segment));
        }
        return pathFactory.createRelativePath(segments);
    }

    private void writeClassNode(SequencerOutput output, PathFactory pathFactory, DateTimeFactory dateFactory, Path classPath, ClassMetadata cmd) {
        output.setProperty(classPath, ClassFileSequencerLexicon.NAME, new Object[]{cmd.getClassName()});
        output.setProperty(classPath, ClassFileSequencerLexicon.SEQUENCED_DATE, new Object[]{dateFactory.create()});
        output.setProperty(classPath, ClassFileSequencerLexicon.SUPER_CLASS_NAME, new Object[]{cmd.getSuperclassName()});
        output.setProperty(classPath, ClassFileSequencerLexicon.VISIBILITY, new Object[]{cmd.getVisibility().getDescription()});
        output.setProperty(classPath, ClassFileSequencerLexicon.ABSTRACT, new Object[]{cmd.isAbstract()});
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACE, new Object[]{cmd.isInterface()});
        output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, new Object[]{cmd.isFinal()});
        output.setProperty(classPath, ClassFileSequencerLexicon.STRICT_FP, new Object[]{cmd.isStrictFp()});
        output.setProperty(classPath, ClassFileSequencerLexicon.INTERFACES, (Object[])cmd.getInterfaces());
        Path constructorsPath = pathFactory.create(classPath, new Name[]{ClassFileSequencerLexicon.CONSTRUCTORS});
        output.setProperty(constructorsPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.CONSTRUCTORS});
        this.writeMethods(output, pathFactory, constructorsPath, cmd.getConstructors());
        Path methodsPath = pathFactory.create(classPath, new Name[]{ClassFileSequencerLexicon.METHODS});
        output.setProperty(methodsPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.METHODS});
        this.writeMethods(output, pathFactory, methodsPath, cmd.getMethods());
        this.writeFieldsNode(output, pathFactory, classPath, cmd.getFields());
        this.writeAnnotationsNode(output, pathFactory, classPath, cmd.getAnnotations());
        if (cmd instanceof EnumMetadata) {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.ENUM});
            output.setProperty(classPath, ClassFileSequencerLexicon.ENUM_VALUES, ((EnumMetadata)cmd).getValues().toArray());
        } else {
            output.setProperty(classPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.CLASS});
        }
    }

    private void writeFieldsNode(SequencerOutput output, PathFactory pathFactory, Path classPath, List<FieldMetadata> fields) {
        Path fieldsPath = pathFactory.create(classPath, new Name[]{ClassFileSequencerLexicon.FIELDS});
        output.setProperty(fieldsPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.FIELDS});
        for (FieldMetadata field : fields) {
            Path fieldPath = pathFactory.create(fieldsPath, field.getName());
            output.setProperty(fieldPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.FIELD});
            output.setProperty(fieldPath, ClassFileSequencerLexicon.NAME, new Object[]{field.getName()});
            output.setProperty(fieldPath, ClassFileSequencerLexicon.TYPE_CLASS_NAME, new Object[]{field.getTypeName()});
            output.setProperty(fieldPath, ClassFileSequencerLexicon.VISIBILITY, new Object[]{field.getVisibility().getDescription()});
            output.setProperty(classPath, ClassFileSequencerLexicon.STATIC, new Object[]{field.isStatic()});
            output.setProperty(classPath, ClassFileSequencerLexicon.FINAL, new Object[]{field.isFinal()});
            output.setProperty(classPath, ClassFileSequencerLexicon.TRANSIENT, new Object[]{field.isTransient()});
            output.setProperty(classPath, ClassFileSequencerLexicon.VOLATILE, new Object[]{field.isVolatile()});
            this.writeAnnotationsNode(output, pathFactory, fieldPath, field.getAnnotations());
        }
    }

    private void writeMethods(SequencerOutput output, PathFactory pathFactory, Path methodsPath, List<MethodMetadata> methods) {
        for (MethodMetadata method : methods) {
            Path methodPath = pathFactory.create(methodsPath, method.getId());
            output.setProperty(methodPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.METHOD});
            output.setProperty(methodPath, ClassFileSequencerLexicon.NAME, new Object[]{method.getName()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.RETURN_TYPE_CLASS_NAME, new Object[]{method.getReturnType()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.VISIBILITY, new Object[]{method.getVisibility().getDescription()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.STATIC, new Object[]{method.isStatic()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.FINAL, new Object[]{method.isFinal()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.ABSTRACT, new Object[]{method.isAbstract()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.STRICT_FP, new Object[]{method.isStrictFp()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.NATIVE, new Object[]{method.isNative()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.SYNCHRONIZED, new Object[]{method.isSynchronized()});
            output.setProperty(methodPath, ClassFileSequencerLexicon.PARAMETERS, method.getParameters().toArray());
            this.writeAnnotationsNode(output, pathFactory, methodPath, method.getAnnotations());
        }
    }

    private void writeAnnotationsNode(SequencerOutput output, PathFactory pathFactory, Path parentPath, List<AnnotationMetadata> annotations) {
        Path annotationsPath = pathFactory.create(parentPath, new Name[]{ClassFileSequencerLexicon.ANNOTATIONS});
        output.setProperty(annotationsPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.ANNOTATIONS});
        for (AnnotationMetadata annotation : annotations) {
            Path annotationPath = pathFactory.create(parentPath, annotation.getAnnotationClassName());
            output.setProperty(annotationPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.ANNOTATION});
            for (Map.Entry<String, String> entry : annotation.getMemberValues().entrySet()) {
                Path annotationMemberPath = pathFactory.create(annotationPath, entry.getKey());
                output.setProperty(annotationMemberPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ClassFileSequencerLexicon.ANNOTATION_MEMBER});
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.NAME, new Object[]{entry.getKey()});
                output.setProperty(annotationMemberPath, ClassFileSequencerLexicon.VALUE, new Object[]{entry.getValue()});
            }
        }
    }
}

