/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.annotation.Annotation;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class AnnotationMetadata {
    private final String annotationClassName;
    private final Map<String, String> memberValues;

    AnnotationMetadata(Annotation annotation) {
        this.annotationClassName = annotation.getTypeName();
        Set memberNames = annotation.getMemberNames();
        if (memberNames != null) {
            HashMap<String, String> members = new HashMap<String, String>(memberNames.size());
            for (Object rawMemberName : memberNames) {
                String memberName = (String)rawMemberName;
                members.put(memberName, annotation.getMemberValue(memberName).toString());
            }
            this.memberValues = Collections.unmodifiableMap(members);
        } else {
            this.memberValues = Collections.emptyMap();
        }
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public Map<String, String> getMemberValues() {
        return this.memberValues;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append('@').append(this.annotationClassName);
        if (!this.memberValues.isEmpty()) {
            buff.append('(');
            boolean first = true;
            for (Map.Entry<String, String> entry : this.memberValues.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    buff.append(", ");
                }
                buff.append(entry.getKey()).append('=').append(entry.getValue());
            }
            buff.append(')');
        }
        return buff.toString();
    }
}

