/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import net.jcip.annotations.Immutable;
import org.jboss.dna.sequencer.classfile.metadata.AnnotationMetadata;
import org.jboss.dna.sequencer.classfile.metadata.FieldMetadata;
import org.jboss.dna.sequencer.classfile.metadata.MethodMetadata;
import org.jboss.dna.sequencer.classfile.metadata.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ClassMetadata {
    private final ClassFile clazz;
    private final List<AnnotationMetadata> annotations;
    private final List<FieldMetadata> fields;
    private final List<MethodMetadata> methods;
    private final List<MethodMetadata> constructors;

    ClassMetadata(ClassFile clazz) {
        this.clazz = clazz;
        this.annotations = this.annotationsFor(clazz);
        this.fields = this.fieldsFor(clazz);
        this.methods = this.methodsFor(clazz);
        this.constructors = this.constructorsFor(clazz);
    }

    private List<AnnotationMetadata> annotationsFor(ClassFile clazz) {
        LinkedList<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();
        for (Object ob : clazz.getAttributes()) {
            AttributeInfo att = (AttributeInfo)ob;
            if (!(att instanceof AnnotationsAttribute)) continue;
            for (Annotation ann : ((AnnotationsAttribute)att).getAnnotations()) {
                annotations.add(new AnnotationMetadata(ann));
            }
        }
        return Collections.unmodifiableList(annotations);
    }

    private List<FieldMetadata> fieldsFor(ClassFile clazz) {
        LinkedList<FieldMetadata> fields = new LinkedList<FieldMetadata>();
        for (Object field : clazz.getFields()) {
            fields.add(new FieldMetadata((FieldInfo)field));
        }
        Collections.sort(fields);
        return Collections.unmodifiableList(fields);
    }

    private List<MethodMetadata> methodsFor(ClassFile clazz) {
        LinkedList<MethodMetadata> methods = new LinkedList<MethodMetadata>();
        for (Object ob : clazz.getMethods()) {
            MethodInfo method = (MethodInfo)ob;
            if (method.isStaticInitializer() || method.isConstructor()) continue;
            methods.add(new MethodMetadata(clazz, method));
        }
        Collections.sort(methods);
        return Collections.unmodifiableList(methods);
    }

    private List<MethodMetadata> constructorsFor(ClassFile clazz) {
        LinkedList<MethodMetadata> ctors = new LinkedList<MethodMetadata>();
        for (Object ob : clazz.getMethods()) {
            MethodInfo method = (MethodInfo)ob;
            if (method.isStaticInitializer() || !method.isConstructor()) continue;
            ctors.add(new MethodMetadata(clazz, method));
        }
        Collections.sort(ctors);
        return Collections.unmodifiableList(ctors);
    }

    public boolean isEnumeration() {
        return false;
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public String getSuperclassName() {
        return this.clazz.getSuperclass();
    }

    public String[] getInterfaces() {
        return this.clazz.getInterfaces();
    }

    public boolean isAbstract() {
        return this.clazz.isAbstract();
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isStrictFp() {
        return 2048 == (0x800 & this.clazz.getAccessFlags());
    }

    public boolean isFinal() {
        return 16 == (0x10 & this.clazz.getAccessFlags());
    }

    public Visibility getVisibility() {
        return Visibility.fromAccessFlags(this.clazz.getAccessFlags());
    }

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public List<MethodMetadata> getMethods() {
        return this.methods;
    }

    public List<MethodMetadata> getConstructors() {
        return this.constructors;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (AnnotationMetadata annotation : this.annotations) {
            buff.append(annotation).append('\n');
        }
        buff.append((Object)this.getVisibility());
        if (this.getVisibility() != Visibility.PACKAGE) {
            buff.append(' ');
        }
        if (this.isAbstract()) {
            if (this.isInterface()) {
                buff.append("interface ");
            } else {
                buff.append("abstract class ");
            }
        } else {
            buff.append("class ");
        }
        if (this.getSuperclassName() != null && !Object.class.getName().equals(this.getSuperclassName())) {
            buff.append(" extends ").append(this.getSuperclassName()).append(" ");
        }
        if (this.getInterfaces().length > 0) {
            boolean first = true;
            buff.append(" implements ");
            for (String interfaceName : this.getInterfaces()) {
                if (first) {
                    first = false;
                } else {
                    buff.append(", ");
                }
                buff.append(interfaceName);
            }
            buff.append(' ');
        }
        buff.append(this.getClassName()).append(" {\n");
        for (FieldMetadata field : this.fields) {
            buff.append('\t').append(field).append('\n');
        }
        if (!this.methods.isEmpty()) {
            buff.append('\n');
        }
        for (MethodMetadata method : this.methods) {
            buff.append('\t').append(method).append('\n');
        }
        buff.append("}");
        return buff.toString();
    }
}

