/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.jackrabbitcdnsupport;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.core.TransientRepository;
import org.jboss.dna.common.util.FileUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class jackrabbitCNDSupportsTest {
    public static final String TESTATA_PATH = "./src/test/resources/";
    public static final String JACKRABBIT_DATA_PATH = "./target/testdata/jackrabbittest/";
    public static final String REPOSITORY_DIRECTORY_PATH = "./target/testdata/jackrabbittest/repository";
    public static final String REPOSITORY_CONFIG_PATH = "./src/test/resources/jackrabbitInMemoryTestRepositoryConfig.xml";
    public static final String USERNAME = "jsmith";
    public static final char[] PASSWORD = "secret".toCharArray();
    private Repository repository;
    private Session session;

    @Before
    public void beforeEach() throws Exception {
        FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        this.repository = new TransientRepository(REPOSITORY_CONFIG_PATH, REPOSITORY_DIRECTORY_PATH);
        SimpleCredentials creds = new SimpleCredentials(USERNAME, PASSWORD);
        this.session = this.repository.login((Credentials)creds);
        Assert.assertNotNull((Object)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
            FileUtil.delete((String)JACKRABBIT_DATA_PATH);
        }
    }

    @Test
    public void shouldSupportCNDNodeTypes() throws Exception {
        JackrabbitNodeTypeManager ntm = (JackrabbitNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
        Assert.assertNotNull((Object)ntm);
        FileInputStream cndFile = new FileInputStream("./src/test/resources/java-source-artifact.cnd");
        Assert.assertNotNull((Object)cndFile);
        NodeType[] nodeTypes = ntm.registerNodeTypes((InputStream)cndFile, "text/x-jcr-cnd");
        Assert.assertTrue((nodeTypes.length > 0 ? 1 : 0) != 0);
        for (NodeType nodeType : nodeTypes) {
            System.out.println("node type name: " + nodeType.getName());
        }
    }

    @Test
    public void testMap() {
        Set keys;
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("login", "field.isNull");
        if (!errors.containsKey("login")) {
            errors.put("login", "field.regexp");
        }
        Assert.assertTrue(((keys = errors.keySet()).size() == 1 ? 1 : 0) != 0);
        Collection values = errors.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            System.out.println((String)i.next());
        }
    }
}

