/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.msoffice;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.graph.sequencers.SequencerOutput;
import org.jboss.dna.graph.sequencers.StreamSequencer;
import org.jboss.dna.sequencer.msoffice.MSOfficeMetadata;
import org.jboss.dna.sequencer.msoffice.MSOfficeMetadataReader;
import org.jboss.dna.sequencer.msoffice.excel.ExcelMetadata;
import org.jboss.dna.sequencer.msoffice.excel.ExcelMetadataReader;
import org.jboss.dna.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.jboss.dna.sequencer.msoffice.powerpoint.SlideMetadata;
import org.jboss.dna.sequencer.msoffice.word.WordMetadataReader;

public class MSOfficeMetadataSequencer
implements StreamSequencer {
    public static final String METADATA_NODE = "msoffice:metadata";
    public static final String MSOFFICE_PRIMARY_TYPE = "jcr:primaryType";
    public static final String MSOFFICE_TITLE = "msoffice:title";
    public static final String MSOFFICE_SUBJECT = "msoffice:subject";
    public static final String MSOFFICE_AUTHOR = "msoffice:author";
    public static final String MSOFFICE_KEYWORDS = "msoffice:keywords";
    public static final String MSOFFICE_COMMENT = "msoffice:comment";
    public static final String MSOFFICE_TEMPLATE = "msoffice:template";
    public static final String MSOFFICE_LAST_SAVED_BY = "msoffice:last_saved_by";
    public static final String MSOFFICE_REVISION = "msoffice:revision";
    public static final String MSOFFICE_TOTAL_EDITING_TIME = "msoffice:total_editing_time";
    public static final String MSOFFICE_LAST_PRINTED = "msoffice:last_printed";
    public static final String MSOFFICE_CREATED = "msoffice:created";
    public static final String MSOFFICE_SAVED = "msoffice:saved";
    public static final String MSOFFICE_PAGES = "msoffice:pages";
    public static final String MSOFFICE_WORDS = "msoffice:words";
    public static final String MSOFFICE_CHARACTERS = "msoffice:characters";
    public static final String MSOFFICE_CREATING_APPLICATION = "msoffice:creating_application";
    public static final String MSOFFICE_THUMBNAIL = "msoffice:thumbnail";
    public static final String POWERPOINT_SLIDE_NODE = "msoffice:slide";
    public static final String SLIDE_TITLE = "msoffice:title";
    public static final String SLIDE_TEXT = "msoffice:text";
    public static final String SLIDE_NOTES = "msoffice:notes";
    public static final String SLIDE_THUMBNAIL = "msoffice:thumbnail";
    public static final String EXCEL_FULL_CONTENT = "msoffice:full_contents";
    public static final String EXCEL_SHEET_NAME = "msoffice:sheet_name";

    public void sequence(InputStream stream, SequencerOutput output, SequencerContext context) {
        MSOfficeMetadata metadata = MSOfficeMetadataReader.instance(stream);
        String mimeType = context.getMimeType();
        if (metadata == null) {
            return;
        }
        output.setProperty(METADATA_NODE, MSOFFICE_PRIMARY_TYPE, new Object[]{METADATA_NODE});
        output.setProperty(METADATA_NODE, "msoffice:title", new Object[]{metadata.getTitle()});
        output.setProperty(METADATA_NODE, MSOFFICE_SUBJECT, new Object[]{metadata.getSubject()});
        output.setProperty(METADATA_NODE, MSOFFICE_AUTHOR, new Object[]{metadata.getAuthor()});
        output.setProperty(METADATA_NODE, MSOFFICE_KEYWORDS, new Object[]{metadata.getKeywords()});
        output.setProperty(METADATA_NODE, MSOFFICE_COMMENT, new Object[]{metadata.getComment()});
        output.setProperty(METADATA_NODE, MSOFFICE_TEMPLATE, new Object[]{metadata.getTemplate()});
        output.setProperty(METADATA_NODE, MSOFFICE_LAST_SAVED_BY, new Object[]{metadata.getLastSavedBy()});
        output.setProperty(METADATA_NODE, MSOFFICE_REVISION, new Object[]{metadata.getRevision()});
        output.setProperty(METADATA_NODE, MSOFFICE_TOTAL_EDITING_TIME, new Object[]{metadata.getTotalEditingTime()});
        output.setProperty(METADATA_NODE, MSOFFICE_LAST_PRINTED, new Object[]{metadata.getLastPrinted()});
        output.setProperty(METADATA_NODE, MSOFFICE_CREATED, new Object[]{metadata.getCreated()});
        output.setProperty(METADATA_NODE, MSOFFICE_SAVED, new Object[]{metadata.getSaved()});
        output.setProperty(METADATA_NODE, MSOFFICE_PAGES, new Object[]{metadata.getPages()});
        output.setProperty(METADATA_NODE, MSOFFICE_WORDS, new Object[]{metadata.getWords()});
        output.setProperty(METADATA_NODE, MSOFFICE_CHARACTERS, new Object[]{metadata.getCharacters()});
        output.setProperty(METADATA_NODE, MSOFFICE_CREATING_APPLICATION, new Object[]{metadata.getCreatingApplication()});
        output.setProperty(METADATA_NODE, "msoffice:thumbnail", new Object[]{metadata.getThumbnail()});
        if (mimeType.equals("application/vnd.ms-powerpoint")) {
            try {
                List<SlideMetadata> ppt_metadata = PowerPointMetadataReader.instance(stream);
                if (ppt_metadata != null) {
                    for (SlideMetadata sm : ppt_metadata) {
                        output.setProperty("msoffice:metadata/msoffice:slide", "msoffice:title", new Object[]{sm.getTitle()});
                        output.setProperty("msoffice:metadata/msoffice:slide", SLIDE_TEXT, new Object[]{sm.getText()});
                        output.setProperty("msoffice:metadata/msoffice:slide", SLIDE_NOTES, new Object[]{sm.getNotes()});
                        output.setProperty("msoffice:metadata/msoffice:slide", "msoffice:thumbnail", new Object[]{sm.getThumbnail()});
                    }
                }
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the PowerPoint metadata", new Object[0]);
            }
        }
        if (mimeType.equals("application/vnd.ms-word")) {
            try {
                WordMetadataReader.invoke(stream);
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the Word document metadata", new Object[0]);
            }
        }
        if (mimeType.equals("application/vnd.ms-excel")) {
            try {
                ExcelMetadata excel_metadata = ExcelMetadataReader.instance(stream);
                if (excel_metadata != null) {
                    output.setProperty(METADATA_NODE, EXCEL_FULL_CONTENT, new Object[]{excel_metadata.getText()});
                    for (String sheet : excel_metadata.getSheets()) {
                        output.setProperty(METADATA_NODE, EXCEL_SHEET_NAME, new Object[]{sheet});
                    }
                }
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the Excel metadata", new Object[0]);
            }
        }
    }
}

