/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.msoffice.excel;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.sequencer.msoffice.excel.ExcelMetadata;
import org.jboss.dna.sequencer.msoffice.excel.ExcelMetadataReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExcelMetadataReaderTest {
    private ExcelMetadata excelReader;
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestDocument(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForExcel() throws Exception {
        this.excelReader = ExcelMetadataReader.instance((InputStream)this.getTestDocument("excel.xls"));
        Assert.assertThat((Object)this.excelReader.getSheets().contains("MySheet2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.excelReader.getText().startsWith("This is a text"), (Matcher)Is.is((Object)true));
    }
}

