/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.msoffice.powerpoint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.jboss.dna.sequencer.msoffice.powerpoint.SlideMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerPointMetadataReader {
    public static List<SlideMetadata> instance(InputStream stream) throws IOException {
        SlideShow slideshow = new SlideShow(stream);
        Slide[] slides = slideshow.getSlides();
        ArrayList<SlideMetadata> slidesMetadata = new ArrayList<SlideMetadata>();
        for (Slide slide : slides) {
            SlideMetadata slideMetadata = new SlideMetadata();
            slideMetadata.setTitle(slide.getTitle());
            for (TextRun textRun : slide.getNotesSheet().getTextRuns()) {
                if (slideMetadata.getNotes() == null) {
                    slideMetadata.setNotes("");
                }
                slideMetadata.setNotes(slideMetadata.getNotes() + textRun.getText());
            }
            for (TextRun textRun : slide.getTextRuns()) {
                if (textRun.getText().equals(slideMetadata.getTitle()) || textRun.getText() == null) continue;
                if (slideMetadata.getText() == null) {
                    slideMetadata.setText("");
                }
                slideMetadata.setText(slideMetadata.getText() + textRun.getText());
            }
            Dimension pgsize = slideshow.getPageSize();
            BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
            slide.draw(graphics);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            slideMetadata.setThumbnail(out.toByteArray());
            slidesMetadata.add(slideMetadata);
        }
        return slidesMetadata;
    }
}

